<!-- Navbar Vertical -->
<aside
    class="js-navbar-vertical-aside navbar navbar-vertical-aside navbar-vertical navbar-vertical-fixed navbar-expand-xl navbar-vertical-aside-initialized
    <?php echo e(in_array(session()->get('themeMode'), [null, 'auto'] )?  'navbar-dark bg-dark ' : 'navbar-light bg-white'); ?>">
    <div class="navbar-vertical-container">
        <div class="navbar-vertical-footer-offset">
            <!-- Logo -->
            <a class="navbar-brand" href="<?php echo e(route('admin.dashboard')); ?>" aria-label="<?php echo e($basicControl->site_title); ?>">
                <img class="navbar-brand-logo navbar-brand-logo-auto"
                     src="<?php echo e(getFile(session()->get('themeMode') == 'auto'?$basicControl->admin_dark_mode_logo_driver : $basicControl->admin_logo_driver, session()->get('themeMode') == 'auto'?$basicControl->admin_dark_mode_logo:$basicControl->admin_logo, true)); ?>"
                     alt="<?php echo e($basicControl->site_title); ?> Logo"
                     data-hs-theme-appearance="default">

                <img class="navbar-brand-logo"
                     src="<?php echo e(getFile($basicControl->admin_dark_mode_logo_driver, $basicControl->admin_dark_mode_logo, true)); ?>"
                     alt="<?php echo e($basicControl->site_title); ?> Logo"
                     data-hs-theme-appearance="dark">

                <img class="navbar-brand-logo-mini"
                     src="<?php echo e(getFile($basicControl->favicon_driver, $basicControl->favicon, true)); ?>"
                     alt="<?php echo e($basicControl->site_title); ?> Logo"
                     data-hs-theme-appearance="default">
                <img class="navbar-brand-logo-mini"
                     src="<?php echo e(getFile($basicControl->favicon_driver, $basicControl->favicon, true)); ?>"
                     alt="Logo"
                     data-hs-theme-appearance="dark">
            </a>
            <!-- End Logo -->

            <!-- Navbar Vertical Toggle -->
            <button type="button" class="js-navbar-vertical-aside-toggle-invoker navbar-aside-toggler">
                <i class="bi-arrow-bar-left navbar-toggler-short-align"
                   data-bs-template='<div class="tooltip d-none d-md-block" role="tooltip"><div class="arrow"></div><div class="tooltip-inner"></div></div>'
                   data-bs-toggle="tooltip"
                   data-bs-placement="right"
                   title="Collapse">
                </i>
                <i
                    class="bi-arrow-bar-right navbar-toggler-full-align"
                    data-bs-template='<div class="tooltip d-none d-md-block" role="tooltip"><div class="arrow"></div><div class="tooltip-inner"></div></div>'
                    data-bs-toggle="tooltip"
                    data-bs-placement="right"
                    title="Expand"
                ></i>
            </button>
            <!-- End Navbar Vertical Toggle -->


            <!-- Content -->
            <div class="navbar-vertical-content">
                <div id="navbarVerticalMenu" class="nav nav-pills nav-vertical card-navbar-nav">

                    <div class="nav-item">
                        <a class="nav-link <?php echo e(menuActive(['admin.dashboard'])); ?>"
                           href="<?php echo e(route('admin.dashboard')); ?>">
                            <i class="bi-house-door nav-icon"></i>
                            <span class="nav-link-title"><?php echo app('translator')->get("Dashboard"); ?></span>
                        </a>
                    </div>

                    <span class="dropdown-header mt-3"> <?php echo app('translator')->get("Manage Plan"); ?></span>
                    <div class="nav-item">
                        <a class="nav-link <?php echo e(menuActive(['admin.schedule.index','admin.schedule.create','admin.schedule.edit'])); ?>"
                           href="<?php echo e(route('admin.schedule.index')); ?>">
                            <i class="bi bi-clock nav-icon"></i>
                            <span class="nav-link-title"><?php echo app('translator')->get("Schedules"); ?></span>
                        </a>
                    </div>
                    <div class="nav-item">
                        <a class="nav-link <?php echo e(menuActive(['admin.plan.index','admin.plan.create','admin.plan.edit'])); ?>"
                           href="<?php echo e(route('admin.plan.index')); ?>">
                            <i class="bi bi-boxes nav-icon"></i>
                            <span class="nav-link-title"><?php echo app('translator')->get("Plans"); ?></span>
                        </a>
                    </div>
                    <div class="nav-item">
                        <a class="nav-link <?php echo e(menuActive(['admin.purchase.plan.index'])); ?>"
                           href="<?php echo e(route('admin.purchase.plan.index')); ?>">
                            <i class="bi bi-credit-card nav-icon"></i>
                            <span class="nav-link-title"><?php echo app('translator')->get("Purchase Plan"); ?></span>
                        </a>
                    </div>

                    <span class="dropdown-header mt-3"><?php echo app('translator')->get('Manage Module'); ?></span>
                    <small class="bi-three-dots nav-subtitle-replacer"></small>

                    <div class="nav-item">
                        <a class="nav-link <?php echo e(menuActive(['admin.order.index','admin.order.details'])); ?>"
                           href="<?php echo e(route('admin.order.index')); ?>" data-placement="left">
                            <i class="fal fa-tags nav-icon"></i>
                            <span class="nav-link-title"><?php echo app('translator')->get("Order Items"); ?></span>
                        </a>
                    </div>

                    <div class="nav-item">
                        <a class="nav-link <?php echo e(menuActive(['admin.store.index','admin.store.details'])); ?>"
                           href="<?php echo e(route('admin.store.index')); ?>" data-placement="left">
                            <i class="fal fa-store nav-icon"></i>
                            <span class="nav-link-title"><?php echo app('translator')->get("Stores"); ?></span>
                        </a>
                    </div>

                    <div class="nav-item">
                        <a class="nav-link dropdown-toggle <?php echo e(menuActive(['admin.menu.index','admin.menu.optional','admin.menu.details'], 3)); ?>"
                           href="#navbarVerticalMenuItemMenu"
                           role="button"
                           data-bs-toggle="collapse"
                           data-bs-target="#navbarVerticalMenuItemMenu"
                           aria-expanded="false"
                           aria-controls="navbarVerticalMenuItemMenu">
                            <i class="fal fa-utensils nav-icon"></i>
                            <span class="nav-link-title"><?php echo app('translator')->get("Menu Item"); ?></span>
                        </a>
                        <div id="navbarVerticalMenuItemMenu"
                             class="nav-collapse collapse <?php echo e(menuActive(['admin.menu.index','admin.menu.optional','admin.menu.details'], 2)); ?>"
                             data-bs-parent="#navbarVerticalMenuItemMenu">
                            <a class="nav-link <?php echo e(menuActive(['admin.menu.index','admin.menu.details'])); ?>"
                               href="<?php echo e(route('admin.menu.index')); ?>"><?php echo app('translator')->get("Menu"); ?>
                            </a>
                            <a class="nav-link <?php echo e(menuActive('admin.menu.optional')); ?>"
                               href="<?php echo e(route('admin.menu.optional')); ?>"><?php echo app('translator')->get("Optional Menu"); ?>
                            </a>
                        </div>
                    </div>

                    <div class="nav-item">
                        <a class="nav-link <?php echo e(menuActive(['admin.categories.index'])); ?>"
                           href="<?php echo e(route('admin.categories.index')); ?>" data-placement="left">
                            <i class="fal fa-stream nav-icon"></i>
                            <span class="nav-link-title"><?php echo app('translator')->get("Categories"); ?></span>
                        </a>
                    </div>
                    <div class="nav-item">
                        <a class="nav-link <?php echo e(menuActive(['admin.shipping.index'])); ?>"
                           href="<?php echo e(route('admin.shipping.index')); ?>" data-placement="left">
                            <i class="fal fa-dolly-flatbed nav-icon"></i>
                            <span class="nav-link-title"><?php echo app('translator')->get("Shipping"); ?></span>
                        </a>
                    </div>
                    <div class="nav-item">
                        <a class="nav-link <?php echo e(menuActive(['admin.coupon.index'])); ?>"
                           href="<?php echo e(route('admin.coupon.index')); ?>" data-placement="left">
                            <i class="fal fa-receipt nav-icon"></i>
                            <span class="nav-link-title"><?php echo app('translator')->get("Coupon"); ?></span>
                        </a>
                    </div>

                    <span class="dropdown-header mt-3"><?php echo app('translator')->get('Subscriber'); ?></span>
                    <small class="bi-three-dots nav-subtitle-replacer"></small>
                    <div class="nav-item">
                        <a class="nav-link <?php echo e(menuActive(['admin.subscriber','admin.subscriber.send.email.form'])); ?>"
                           href="<?php echo e(route('admin.subscriber')); ?>" data-placement="left">
                            <i class="fas fa-users nav-icon"></i>
                            <span class="nav-link-title"><?php echo app('translator')->get("Subscriber List"); ?></span>
                        </a>
                    </div>

                    <span class="dropdown-header mt-3"><?php echo app('translator')->get('Transactions'); ?></span>
                    <small class="bi-three-dots nav-subtitle-replacer"></small>
                    <div class="nav-item">
                        <a class="nav-link <?php echo e(menuActive(['admin.transaction'])); ?>"
                           href="<?php echo e(route('admin.transaction')); ?>" data-placement="left">
                            <i class="bi bi-send nav-icon"></i>
                            <span class="nav-link-title"><?php echo app('translator')->get("Transaction"); ?></span>
                        </a>
                    </div>

                    <div class="nav-item">
                        <a class="nav-link <?php echo e(menuActive(['admin.payment.log'])); ?>"
                           href="<?php echo e(route('admin.payment.log')); ?>" data-placement="left">
                            <i class="bi bi-credit-card-2-front nav-icon"></i>
                            <span class="nav-link-title"><?php echo app('translator')->get("Payment Log"); ?></span>
                        </a>
                    </div>
                    <div class="nav-item">
                        <a class="nav-link <?php echo e(menuActive(['admin.payment.pending'])); ?>"
                           href="<?php echo e(route('admin.payment.pending')); ?>" data-placement="left">
                            <i class="bi bi-cash nav-icon"></i>
                            <span class="nav-link-title"><?php echo app('translator')->get("Payment Request"); ?></span>
                            <?php if($sidebarCounts->deposit_pending > 0): ?>
                                <span
                                    class="badge bg-primary rounded-pill ms-2"><?php echo e($sidebarCounts->deposit_pending); ?></span>
                            <?php endif; ?>
                        </a>
                    </div>

                    <span class="dropdown-header mt-3"> <?php echo app('translator')->get("Ticket Panel"); ?></span>
                    <small class="bi-three-dots nav-subtitle-replacer"></small>
                    <div class="nav-item">
                        <a class="nav-link dropdown-toggle <?php echo e(menuActive(['admin.ticket', 'admin.ticket.search', 'admin.ticket.view'], 3)); ?>"
                           href="#navbarVerticalTicketMenu"
                           role="button"
                           data-bs-toggle="collapse"
                           data-bs-target="#navbarVerticalTicketMenu"
                           aria-expanded="false"
                           aria-controls="navbarVerticalTicketMenu">
                            <i class="fa-light fa-headset nav-icon"></i>
                            <span class="nav-link-title"><?php echo app('translator')->get("Support Ticket"); ?></span>
                        </a>
                        <div id="navbarVerticalTicketMenu"
                             class="nav-collapse collapse <?php echo e(menuActive(['admin.ticket','admin.ticket.search', 'admin.ticket.view'], 2)); ?>"
                             data-bs-parent="#navbarVerticalTicketMenu">
                            <a class="nav-link <?php echo e(request()->is('admin/tickets/all') ? 'active' : ''); ?>"
                               href="<?php echo e(route('admin.ticket', 'all')); ?>"><?php echo app('translator')->get("All Tickets"); ?>
                            </a>
                            <a class="nav-link <?php echo e(request()->is('admin/tickets/answered') ? 'active' : ''); ?>"
                               href="<?php echo e(route('admin.ticket', 'answered')); ?>"><?php echo app('translator')->get("Answered Ticket"); ?></a>
                            <a class="nav-link <?php echo e(request()->is('admin/tickets/replied') ? 'active' : ''); ?>"
                               href="<?php echo e(route('admin.ticket', 'replied')); ?>"><?php echo app('translator')->get("Replied Ticket"); ?></a>
                            <a class="nav-link <?php echo e(request()->is('admin/tickets/closed') ? 'active' : ''); ?>"
                               href="<?php echo e(route('admin.ticket', 'closed')); ?>"><?php echo app('translator')->get("Closed Ticket"); ?></a>
                        </div>
                    </div>


                    <span class="dropdown-header mt-3"> <?php echo app('translator')->get('Kyc Management'); ?></span>
                    <small class="bi-three-dots nav-subtitle-replacer"></small>
                    <div class="nav-item">
                        <a class="nav-link <?php echo e(menuActive(['admin.kyc.form.list','admin.kyc.edit','admin.kyc.create'])); ?>"
                           href="<?php echo e(route('admin.kyc.form.list')); ?>" data-placement="left">
                            <i class="bi-stickies nav-icon"></i>
                            <span class="nav-link-title"><?php echo app('translator')->get('KYC Setting'); ?></span>
                        </a>
                    </div>

                    <div class="nav-item" <?php echo e(menuActive(['admin.kyc.list*','admin.kyc.view'], 3)); ?>>
                        <a class="nav-link dropdown-toggle collapsed" href="#navbarVerticalKycRequestMenu"
                           role="button"
                           data-bs-toggle="collapse" data-bs-target="#navbarVerticalKycRequestMenu"
                           aria-expanded="false"
                           aria-controls="navbarVerticalKycRequestMenu">
                            <i class="bi bi-person-lines-fill nav-icon"></i>
                            <span class="nav-link-title"><?php echo app('translator')->get("KYC Request"); ?></span>
                        </a>
                        <div id="navbarVerticalKycRequestMenu"
                             class="nav-collapse collapse <?php echo e(menuActive(['admin.kyc.list*','admin.kyc.view'], 2)); ?>"
                             data-bs-parent="#navbarVerticalKycRequestMenu">

                            <a class="nav-link <?php echo e(Request::is('admin/kyc/pending') ? 'active' : ''); ?>"
                               href="<?php echo e(route('admin.kyc.list', 'pending')); ?>">
                                <?php echo app('translator')->get('Pending KYC'); ?>
                                <?php if($sidebarCounts->kyc_pending > 0): ?>
                                    <span
                                        class="badge bg-primary rounded-pill ms-2"><?php echo e($sidebarCounts->kyc_pending); ?></span>
                                <?php endif; ?>
                            </a>
                            <a class="nav-link <?php echo e(Request::is('admin/kyc/approve') ? 'active' : ''); ?>"
                               href="<?php echo e(route('admin.kyc.list', 'approve')); ?>">
                                <?php echo app('translator')->get('Approved KYC'); ?>
                                <?php if($sidebarCounts->kyc_verified > 0): ?>
                                    <span
                                        class="badge bg-primary rounded-pill ms-2"><?php echo e($sidebarCounts->kyc_verified); ?></span>
                                <?php endif; ?>
                            </a>
                            <a class="nav-link <?php echo e(Request::is('admin/kyc/rejected') ? 'active' : ''); ?>"
                               href="<?php echo e(route('admin.kyc.list', 'rejected')); ?>">
                                <?php echo app('translator')->get('Rejected KYC'); ?>
                                <?php if($sidebarCounts->kyc_rejected > 0): ?>
                                    <span
                                        class="badge bg-primary rounded-pill ms-2"><?php echo e($sidebarCounts->kyc_rejected); ?></span>
                                <?php endif; ?>
                            </a>
                        </div>
                    </div>

                    <span class="dropdown-header mt-3"> <?php echo app('translator')->get("User Panel"); ?></span>
                    <small class="bi-three-dots nav-subtitle-replacer"></small>
                    <div class="nav-item">
                        <a class="nav-link dropdown-toggle <?php echo e(menuActive(['admin.users'], 3)); ?>"
                           href="#navbarVerticalUserPanelMenu"
                           role="button"
                           data-bs-toggle="collapse"
                           data-bs-target="#navbarVerticalUserPanelMenu"
                           aria-expanded="false"
                           aria-controls="navbarVerticalUserPanelMenu">
                            <i class="bi-people nav-icon"></i>
                            <span class="nav-link-title"><?php echo app('translator')->get('User Management'); ?></span>
                        </a>
                        <div id="navbarVerticalUserPanelMenu"
                             class="nav-collapse collapse <?php echo e(menuActive(['admin.mail.all.user','admin.users','admin.users.add','admin.user.edit',
                                                                        'admin.user.view.profile','admin.user.transaction','admin.user.payment',
                                                                        'admin.user.payout','admin.user.kyc.list','admin.send.email'], 2)); ?>"
                             data-bs-parent="#navbarVerticalUserPanelMenu">

                            <a class="nav-link <?php echo e(request()->is('admin/users') ? 'active' : ''); ?>"
                               href="<?php echo e(route('admin.users')); ?>">
                                <?php echo app('translator')->get('All User'); ?>
                            </a>

                            <a href="<?php echo e(route('admin.users','active-users')); ?>"
                               class="nav-link d-flex justify-content-between <?php echo e(request()->is('admin/users/active-users') ? 'active' : ''); ?>">
                                <?php echo app('translator')->get('Active Users'); ?>
                                <?php if($sidebarCounts->active_users > 0): ?>
                                    <span
                                        class="badge bg-primary rounded-pill ms-2"><?php echo e($sidebarCounts->active_users); ?></span>
                                <?php endif; ?>
                            </a>
                            <a href="<?php echo e(route('admin.users','blocked-users')); ?>"
                               class="nav-link d-flex justify-content-between <?php echo e(request()->is('admin/users/blocked-users') ? 'active' : ''); ?>">
                                <?php echo app('translator')->get('Blocked Users'); ?>
                                <?php if($sidebarCounts->blocked_users > 0): ?>
                                    <span
                                        class="badge bg-primary rounded-pill ms-2"><?php echo e($sidebarCounts->blocked_users); ?></span>
                                <?php endif; ?>
                            </a>
                            <a href="<?php echo e(route('admin.users','email-unverified')); ?>"
                               class="nav-link d-flex justify-content-between <?php echo e(request()->is('admin/users/email-unverified') ? 'active' : ''); ?>">
                                <?php echo app('translator')->get('Email Unverified'); ?>
                                <?php if($sidebarCounts->email_unverified > 0): ?>
                                    <span
                                        class="badge bg-primary rounded-pill ms-2"><?php echo e($sidebarCounts->email_unverified); ?></span>
                                <?php endif; ?>
                            </a>
                            <a href="<?php echo e(route('admin.users','sms-unverified')); ?>"
                               class="nav-link d-flex justify-content-between <?php echo e(request()->is('admin/users/sms-unverified') ? 'active' : ''); ?>">
                                <?php echo app('translator')->get('Sms Unverified'); ?>
                                <?php if($sidebarCounts->sms_unverified > 0): ?>
                                    <span
                                        class="badge bg-primary rounded-pill ms-2"><?php echo e($sidebarCounts->sms_unverified); ?></span>
                                <?php endif; ?>
                            </a>
                            <a class="nav-link <?php echo e(menuActive(['admin.mail.all.user'])); ?>"
                               href="<?php echo e(route("admin.mail.all.user")); ?>"><?php echo app('translator')->get('Mail To Users'); ?></a>
                        </div>
                    </div>


                    <span class="dropdown-header mt-3"> <?php echo app('translator')->get('SETTINGS PANEL'); ?></span>
                    <small class="bi-three-dots nav-subtitle-replacer"></small>


                    <div class="nav-item">
                        <a class="nav-link <?php echo e(menuActive(controlPanelRoutes())); ?>"
                           href="<?php echo e(route('admin.settings')); ?>" data-placement="left">
                            <i class="bi bi-gear nav-icon"></i>
                            <span class="nav-link-title"><?php echo app('translator')->get('Control Panel'); ?></span>
                        </a>
                    </div>


                    <div
                        class="nav-item <?php echo e(menuActive(['admin.payment.methods', 'admin.edit.payment.methods', 'admin.deposit.manual.index', 'admin.deposit.manual.create', 'admin.deposit.manual.edit'], 3)); ?>">
                        <a class="nav-link dropdown-toggle"
                           href="#navbarVerticalGatewayMenu"
                           role="button"
                           data-bs-toggle="collapse"
                           data-bs-target="#navbarVerticalGatewayMenu"
                           aria-expanded="false"
                           aria-controls="navbarVerticalGatewayMenu">
                            <i class="bi-briefcase nav-icon"></i>
                            <span class="nav-link-title"><?php echo app('translator')->get('Payment Setting'); ?></span>
                        </a>
                        <div id="navbarVerticalGatewayMenu"
                             class="nav-collapse collapse <?php echo e(menuActive(['admin.payment.methods', 'admin.edit.payment.methods', 'admin.deposit.manual.index', 'admin.deposit.manual.create', 'admin.deposit.manual.edit'], 2)); ?>"
                             data-bs-parent="#navbarVerticalGatewayMenu">

                            <a class="nav-link <?php echo e(menuActive(['admin.payment.methods', 'admin.edit.payment.methods',])); ?>"
                               href="<?php echo e(route('admin.payment.methods')); ?>"><?php echo app('translator')->get('Payment Gateway'); ?></a>

                            <a class="nav-link <?php echo e(menuActive([ 'admin.deposit.manual.index', 'admin.deposit.manual.create', 'admin.deposit.manual.edit'])); ?>"
                               href="<?php echo e(route('admin.deposit.manual.index')); ?>"><?php echo app('translator')->get('Manual Gateway'); ?></a>
                        </div>
                    </div>

                    <span class="dropdown-header mt-3"><?php echo app('translator')->get("Themes Settings"); ?></span>
                    <small class="bi-three-dots nav-subtitle-replacer"></small>
                    <div id="navbarVerticalThemeMenu">

                        <div class="nav-item">
                            <a class="nav-link <?php echo e(menuActive(['admin.page.index','admin.create.page','admin.edit.page'])); ?>"
                               href="<?php echo e(route('admin.page.index', basicControl()->theme)); ?>"
                               data-placement="left">
                                <i class="fa-light fa-list nav-icon"></i>
                                <span class="nav-link-title"><?php echo app('translator')->get('Pages'); ?></span>
                            </a>
                        </div>

                        <div class="nav-item">
                            <a class="nav-link <?php echo e(menuActive(['admin.manage.menu'])); ?>"
                               href="<?php echo e(route('admin.manage.menu')); ?>" data-placement="left">
                                <i class="bi-folder2-open nav-icon"></i>
                                <span class="nav-link-title"><?php echo app('translator')->get('Manage Menu'); ?></span>
                            </a>
                        </div>
                    </div>

                    <?php
                        $segments = request()->segments();
                        $last  = end($segments);
                    ?>
                    <div class="nav-item">
                        <a class="nav-link dropdown-toggle <?php echo e(menuActive(['admin.manage.content', 'admin.manage.content.multiple', 'admin.content.item.edit*'], 3)); ?>"
                           href="#navbarVerticalContentsMenu"
                           role="button" data-bs-toggle="collapse"
                           data-bs-target="#navbarVerticalContentsMenu" aria-expanded="false"
                           aria-controls="navbarVerticalContentsMenu">
                            <i class="fa-light fa-pen nav-icon"></i>
                            <span class="nav-link-title"><?php echo app('translator')->get('Manage Content'); ?></span>
                        </a>
                        <div id="navbarVerticalContentsMenu"
                             class="content-manage nav-collapse collapse <?php echo e(menuActive(['admin.manage.content', 'admin.manage.content.multiple', 'admin.content.item.edit*'], 2)); ?>"
                             data-bs-parent="#navbarVerticalContentsMenu">

                            <?php $__currentLoopData = array_diff(array_keys(config('contents')), ['message', 'content_media']); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $keyValue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($keyValue == basicControl()->theme): ?>
                                    <?php $__currentLoopData = config('contents')[$keyValue]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $name => $content): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $contentImage = config('contents.' .$keyValue. '.' . $name . '.contentPreview');
                                        ?>
                                        <div class="contentAll d-flex justify-content-between">
                                            <a class="nav-link contentTitle <?php echo e(($last == $name) ? 'active' : ''); ?>"
                                               href="<?php echo e(route('admin.manage.content', $name)); ?>"><?php echo app('translator')->get(stringToTitle($name)); ?>
                                            </a>
                                            <button class="btn btn-white btn-sm sidebarContentImage contentImage"
                                                    data-theme="<?php echo e(ucwords($keyValue)); ?>"
                                                    data-image="<?php echo e(json_encode($contentImage)); ?>"
                                                    data-bs-toggle="tooltip"
                                                    title="<?php echo e(ucwords(str_replace('_', ' ', $name))); ?> Preview">
                                                <i class="fa-regular fa-eye"></i>
                                            </button>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>


                    <div class="nav-item">
                        <a class="nav-link dropdown-toggle <?php echo e(menuActive(['admin.blog-category.index', 'admin.blog-category.create','admin.blog-category.edit', 'admin.blogs.index', 'admin.blogs.create','admin.blogs.edit*'], 3)); ?>"
                           href="#navbarVerticalBlogMenu"
                           role="button" data-bs-toggle="collapse"
                           data-bs-target="#navbarVerticalBlogMenu" aria-expanded="false"
                           aria-controls="navbarVerticalBlogMenu">
                            <i class="fa-light fa-newspaper nav-icon"></i>
                            <span class="nav-link-title"><?php echo app('translator')->get('Manage Blog'); ?></span>
                        </a>
                        <div id="navbarVerticalBlogMenu"
                             class="nav-collapse collapse <?php echo e(menuActive(['admin.blog-category.index', 'admin.blog-category.create','admin.blog-category.edit', 'admin.blogs.index', 'admin.blogs.create','admin.blogs.edit*'], 2)); ?>"
                             data-bs-parent="#navbarVerticalBlogMenu">
                            <a class="nav-link <?php echo e(menuActive(['admin.blog-category.index', 'admin.blog-category.create','admin.blog-category.edit'])); ?>"
                               href="<?php echo e(route('admin.blog-category.index')); ?>"><?php echo app('translator')->get('Blog Category'); ?></a>

                            <a class="nav-link <?php echo e(menuActive(['admin.blogs.index', 'admin.blogs.create','admin.blogs.edit*'])); ?>"
                               href="<?php echo e(route('admin.blogs.index')); ?>"><?php echo app('translator')->get('Blog'); ?></a>
                        </div>
                    </div>


                    <div class="nav-item">
                        <a class="nav-link"
                           href="<?php echo e(route('clear')); ?>" data-placement="left">
                            <i class="bi bi-radioactive nav-icon"></i>
                            <span class="nav-link-title"><?php echo app('translator')->get('Clear Cache'); ?></span>
                        </a>
                    </div>

                    <?php $__currentLoopData = collect(config('generalsettings.settings')); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $setting): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="nav-item d-none">
                            <a class="nav-link  <?php echo e(isMenuActive($setting['route'])); ?>"
                               href="<?php echo e(getRoute($setting['route'], $setting['route_segment'] ?? null)); ?>">
                                <i class="<?php echo e($setting['icon']); ?> nav-icon"></i>
                                <span class="nav-link-title"><?php echo e(__(getTitle($key.' '.'Settings'))); ?></span>
                            </a>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                </div>

                <div class="navbar-vertical-footer">
                    <ul class="navbar-vertical-footer-list">
                        <li class="navbar-vertical-footer-list-item">
                            <span class="dropdown-header"><?php echo app('translator')->get('Version 3.0'); ?></span>
                        </li>
                        <li class="navbar-vertical-footer-list-item">
                            <div class="dropdown dropup">
                                <button type="button" class="btn btn-ghost-secondary btn-icon rounded-circle"
                                        id="selectThemeDropdown" data-bs-toggle="dropdown" aria-expanded="false"
                                        data-bs-dropdown-animation></button>
                                <div class="dropdown-menu navbar-dropdown-menu navbar-dropdown-menu-borderless"
                                     aria-labelledby="selectThemeDropdown">
                                    <a class="dropdown-item" href="javascript:void(0)" data-icon="bi-moon-stars"
                                       data-value="auto">
                                        <i class="bi-moon-stars me-2"></i>
                                        <span class="text-truncate"
                                              title="Auto (system default)"><?php echo app('translator')->get("Default"); ?></span>
                                    </a>
                                    <a class="dropdown-item" href="javascript:void(0)" data-icon="bi-brightness-high"
                                       data-value="default">
                                        <i class="bi-brightness-high me-2"></i>
                                        <span class="text-truncate"
                                              title="Default (light mode)"><?php echo app('translator')->get("Light Mode"); ?></span>
                                    </a>
                                    <a class="dropdown-item active" href="javascript:void(0)" data-icon="bi-moon"
                                       data-value="dark">
                                        <i class="bi-moon me-2"></i>
                                        <span class="text-truncate" title="Dark"><?php echo app('translator')->get("Dark Mode"); ?></span>
                                    </a>
                                </div>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</aside>

<?php $__env->startPush('script'); ?>
    <script>
        'use strict';
        $('.sidebarContentImage').on('click', function () {
            const baseUrl = "<?php echo e(asset('')); ?>";
            var themeName = $(this).data('theme');
            var imageData = $(this).data('image');

            let items = Object.keys(imageData).map(function (key) {
                return {
                    src: baseUrl + imageData[key],
                    type: 'image',
                    title: themeName + ' Theme > ' + key + ' Section'
                };
            });
            $.magnificPopup.open({
                items: items,
                gallery: {
                    enabled: true
                },
                type: 'image',
                image: {
                    titleSrc: function (item) {
                        console.log(item)
                        return `<div class="mfp-title-overlay"><h5>${item.title || 'Image Title'}</h5></div>`;
                    }
                }
            });
        });
    </script>
<?php $__env->stopPush(); ?>


<?php /**PATH D:\server\htdocs\FoodyFriend-v3\DEMO\resources\views/admin/layouts/sidebar.blade.php ENDPATH**/ ?>