@extends(template().'layouts.user')
@section('page_title',__('New Ticket'))

@section('content')
    <div class="container-fluid">
        <div class="main row">
            <div class="col-12">
                <div class="dashboard-heading">
                    <h2 class="mb-0">@lang('New Ticket')</h2>
                </div>
                <section class="profile-setting">
                    <div class="sidebar-wrapper">
                        <form action="{{route('user.ticket.store')}}" method="post"
                              enctype="multipart/form-data">
                            @csrf
                            <div class="input-box mb-3">
                                <label for="subject">@lang('Subject')</label>
                                <input type="text" name="subject" placeholder="@lang('Subject')"
                                       value="{{ old('subject') }}"
                                       class="form-control">
                                <div class="text-danger">
                                    @error('subject') @lang($message) @enderror
                                </div>
                            </div>
                            <div class="input-box mb-3">
                                <label for="message">@lang('Message')</label>
                                <textarea name="message" rows="5"
                                          class="form-control @error('note') is-invalid @enderror">{{ old('message') }}</textarea>
                                <div class="text-danger">
                                    @error('message') @lang($message) @enderror
                                </div>
                            </div>
                            <div class="input-box">
                                <div class="attach-file">
                                    <span class="prev"> <i class="fa-duotone fa-link"></i> </span>
                                    <input class="form-control" name="attachments[]" accept="image/*"
                                           type="file" multiple/>
                                </div>
                                <p class="text-danger select-files-count"></p>
                                @error('attachments')
                                <div class="text-danger"> @lang($message) </div>
                                @enderror
                            </div>
                            <button type="submit" class="btn-custom mt-3">
                                @lang('Create Ticket')
                            </button>
                        </form>
                    </div>
                </section>
            </div>
        </div>
    </div>

@endsection
@push('script')
    <script>
        'use strict';
        $(document).on('change', '#upload', function () {
            var fileCount = $(this)[0].files.length;
            $('.select-files-count').text(fileCount + ' file(s) selected');
        });
    </script>
@endpush
