@extends(template().'layouts.user')
@section('page_title',__('Update Menu'))

@section('content')
	<div class="container-fluid">
		<div class="main row">
			<div class="col-12">
				<div class="dashboard-heading">
					<h2 class="mb-0">@lang('Update Menu')</h2>
				</div>
				<section class="profile-setting">
					<div class="sidebar-wrapper">
						<form action="{{ route('user.store.menu.edit',$product->id) }}" method="post"
							  enctype="multipart/form-data">
							@csrf
							<div class="row">
								<div class="col-md-4 mb-3">
									<div class="input-box form-group">
										<label for="Store">@lang('Store')</label>
										<select name="store[]"
												class="store_select2 form-control @error('store') is-invalid @enderror"
												multiple="multiple" required>
											@forelse($stores as $store)
												<option  value="{{$store->id}}" @foreach($product->productStores as $productStore)
													{{$productStore->store_id == $store->id ? 'selected':''}}
													@endforeach>{{$store->name}}</option>
											@empty
											@endforelse
										</select>
										<div class="invalid-feedback">
											@error('store') @lang($message) @enderror
										</div>
									</div>
								</div>
								<div class="col-md-4 mb-3">
									<div class="input-box form-group">
										<label for="Category">@lang('Category')</label>
										<select name="category"
												class="form-select form-control-sm @error('category') is-invalid @enderror"
												required>
											<option disabled selected
													value="">@lang('Select Category')</option>
											@forelse($categories as $category)
												<option
													value="{{$category->id}}" {{$product->category_id == $category->id ? 'selected':''}}>{{$category->name}}</option>
											@empty
											@endforelse
										</select>
										<div class="invalid-feedback">
											@error('category') @lang($message) @enderror
										</div>
									</div>
								</div>
								<div class="col-md-4 mb-3">
									<div class="input-box form-group">
										<label for="Attribute Name">@lang('Menu Name')</label>
										<input type="text" value="{{ $product->name }}"
											   name="name"
											   class="form-control @error('name') is-invalid @enderror"
											   autocomplete="off" required>
										<div class="invalid-feedback">
											@error('name') @lang($message) @enderror
										</div>
									</div>
								</div>
							</div>
							<div class="row">
								<div class="col-md-4 mb-3">
									<div class="input-box form-group">
										<label for="Price">@lang('Price')</label>
										<div class="input-group">
											<input type="text" value="{{ $product->price }}"
												   name="price"
												   class="form-control @error('price') is-invalid @enderror"
												   autocomplete="off" required>
											<button type="button" class="btn-modify">
												<span class="">{{ basicControl()->base_currency }}</span>
											</button>
											<div class="invalid-feedback">
												@error('price') @lang($message) @enderror
											</div>
										</div>
									</div>
								</div>
								<div class="col-md-4 mb-3">
									<div class="input-box form-group">
										<label for="SKU">@lang('SKU')</label>
										<input type="text" value="{{ $product->sku }}"
											   name="sku"
											   class="form-control @error('sku') is-invalid @enderror"
											   autocomplete="off" required>
										<div class="invalid-feedback">
											@error('sku') @lang($message) @enderror
										</div>
									</div>
								</div>
								<div class="col-md-4 mb-3">
									<div class="input-box form-group">
										<label for="Tag">@lang('Tag (optional)')</label>
										<input type="text" value="{{ $product->tag }}"
											   name="tag"
											   class="form-control"
											   autocomplete="off">
									</div>
								</div>
							</div>
							<div class="row mt-3">
								<div class="col-sm-12 col-md-4 mb-3 input-box">
									<label>@lang('Image')</label>
									<div class="form-group position-relative">
										<div class="image-input z0">
											<label for="image-upload" id="image-label"><i
													class="fas fa-upload"></i></label>
											<input type="file" id="image" name="image"
												   placeholder="@lang('Choose image')"
												   class="image-preview">
											<img id="image_preview_container" class="preview-image"
												 src="{{ getFile($product->driver,$product->image) }}"
												 alt="@lang('preview image')">

										</div>
									</div>
									@if(config("filelocation.product.size"))
										<span class="text-warning">{{trans('Image size should be')}} {{config("filelocation.product.size")}} {{trans('px')}}</span>
									@endif
								</div>
								<div class="col-md-4 mb-2">
									<div class="input-box form-group">
										<label for="Store">@lang('Extra Frequency (Optional)')</label>
										<select name="extra_products[]"
												class="extra_prducts_select2 form-control @error('extra_products') is-invalid @enderror"
												multiple="multiple">
											@forelse($optionalProducts as $optionalProduct)
												<option
													value="{{$optionalProduct->id}}" {{in_array($optionalProduct->id,$product->extra_products) == true ? 'selected':''}}>{{$optionalProduct->name}}
													({{config('basic.currency_symbol')}}{{$optionalProduct->price}})
												</option>
											@empty
											@endforelse
										</select>
										<div class="invalid-feedback">
											@error('extra_products') @lang($message) @enderror
										</div>
									</div>
								</div>
								<div class="input-box col-md-4">
									<label>@lang('Status')</label>
									<div class="selectgroup w-100">
										<label class="selectgroup-item">
											<input type="radio" name="status"
												   value="0"
												   class="selectgroup-input" {{$product->status == 0 ? 'checked':''}}>
											<span class="selectgroup-button">@lang('OFF')</span>
										</label>
										<label class="selectgroup-item">
											<input type="radio" name="status"
												   value="1"
												   class="selectgroup-input" {{$product->status == 1 ? 'checked':''}}>
											<span class="selectgroup-button">@lang('ON')</span>
										</label>
									</div>
								</div>
							</div>
							<div class="color-dynamic">
								<div class="d-flex justify-content-between">
									<h6 class="font-weight-bold text-dark">@lang('Variant Lists (Optional)')</h6>
									<button type="button"
											class="btn btn-dark btn-sm mb-3" id="generate"><i
											class="fa fa-plus-circle"></i>
										@lang('Add Variant')</button>
								</div>
								<div class="row addedField">
									@if($product->variants)
										@foreach($product->variants as $variant)
											<div class="input-box col-md-12 my-2">
												<div class="form-group">
													<div class="input-group">
														<input name="variant_name[]" class="form-control " type="text"
															   value="{{$variant->variant_name}}">
														<input name="variant_price[]" class="form-control "
															   type="number"
															   step="0.01" value="{{$variant->variant_price}}"
															   placeholder="{{trans('Price')}}">
														<button type="button" class="btn-modify">
															<span class="">{{ basicControl()->base_currency }}</span>
														</button>
														<span class="input-group-btn">
															<button class="btn btn-danger delete_desc" type="button">
																<i class="fa fa-times"></i>
															</button>
                                                        </span>
													</div>
												</div>
											</div>
										@endforeach
									@endif
								</div>
							</div>
							<div class="row mt-3">
								<div class="col-md-12">
									<div class="input-box form-group">
										<label
											for="Description">@lang('Description (optional)')</label>
										<textarea
											class="form-control summernote"
											name="description"
											rows="5">{{$product->description}}</textarea>
										<div class="invalid-feedback">
											@error('description') @lang($message) @enderror
										</div>
									</div>
								</div>
							</div>
							<button type="submit" class="btn-custom mt-3">@lang('Save Changes')</button>
						</form>
					</div>
				</section>
			</div>
		</div>
	</div>
@endsection

@push('css-lib')
    <link rel="stylesheet" href="{{ asset($themeTrue.'/css/bootstrap-select.min.css') }}">
@endpush
@push('js-lib')
    <script src="{{ asset($themeTrue.'/js/bootstrap-select.min.js') }}"></script>
@endpush

@push('script')
	<script>
		'use strict';
		$(document).ready(function () {
			$(".store_select2").select2({
				width: '100%',
				minimumResultsForSearch: -1,
				placeholder: '@lang("Select Stores")',
			});
			$(".extra_prducts_select2").select2({
				width: '100%',
				minimumResultsForSearch: -1,
				placeholder: '@lang("Select extra frequency")',
			});
		});

		$(document).on('change', '.image-preview', function () {
			let reader = new FileReader();
			reader.onload = (e) => {
				$('#image_preview_container').attr('src', e.target.result);
			}
			reader.readAsDataURL(this.files[0]);
		});

		$(document).on('click', '#generate', function () {
			var form = `<div class="input-box col-md-12 my-2">
                                <div class="form-group">
                                    <div class="input-group">
                                        <input name="variant_name[]" class="form-control " type="text" value="" placeholder="{{trans('Variant Name')}}">
                                        <input name="variant_price[]" class="form-control " type="integer" step="0.01" value="0.00" placeholder="{{trans('Price')}}">
                                        <button type="button" class="btn-modify">
												<span class="">{{ basicControl()->base_currency }}</span>
											</button>
                                        <span class="input-group-btn">
                                            <button class="btn btn-danger delete_desc" type="button">
                                                <i class="fa fa-times"></i>
                                            </button>
                                        </span>
                                    </div>
                                </div>
                            </div> `;
			$('.addedField').append(form)
		});

		$(document).on('click', '.delete_desc', function () {
			$(this).closest('.input-box').remove();
		});

	</script>
@endpush

