@extends(template().'layouts.user')
@section('page_title',__('Manage Schedule'))

@section('content')
	<div class="container-fluid">
		<div class="main row">
			<div class="col-12">
				@if($stores)
					<section class="profile-setting">
						<div class="sidebar-wrapper">
							<div class="idance">
								<div class="schedule content-block">
									<div class="container">
										<div class="timetable">

											@php
												$lastSeg = collect(request()->segments())->last();
											@endphp
											<nav class="nav nav-tabs">
												@foreach($stores as $key => $store)
													<a href="{{route('user.store.schedules',$store->id)}}"
													   class="nav-link {{($lastSeg == 'schedule' && $key == 0)? 'active':''}} {{($lastSeg == $store->id )?'active':''}}">{{$store->name}}</a>
												@endforeach
											</nav>
											<form action="{{route('user.store.schedule.update',$storeId)}}" method="post">
												@csrf
												<div class="tab-content">
													<div class="tab-pane show active">
														<div class="row">
															<!-- Schedule Item 1 -->
															<div class="col-md-6 input-box">
																<div class="timetable-item">
																	<div class="timetable-item-img">
																		<img
																			src="{{asset($themeTrue.'images/monday.png')}}"
																			alt="Contemporary Dance">
																	</div>
																	<div class="timetable-item-main">
																		<div class="row">
																			<div class="col-md-6">
																				<label>@lang('Form')</label>
																				<input type="time" name="from[]"
																					   class="form-control"
																					   value="{{$day['monday']->from}}">
																			</div>
																			<div class="col-md-6">
																				<label>@lang('To')</label>
																				<input type="time" name="to[]"
																					   class="form-control"
																					   value="{{$day['monday']->to}}">
																			</div>
																		</div>
																		<div class="form-check mt-2">
																			<input class="form-check-input"
																				   name="offday[]"
																				   type="checkbox" value="monday"
																				   id="flexCheckChecked" {{($day['monday']->off_day == 1)?'checked':''}}>
																			<label class="form-check-label"
																				   for="flexCheckChecked">
																				@lang('Whole day off')
																			</label>
																		</div>
																	</div>
																</div>
															</div>

															<!-- Schedule Item 2 -->
															<div class="col-md-6 input-box">
																<div class="timetable-item">
																	<div class="timetable-item-img">
																		<img
																			src="{{asset($themeTrue.'images/tuesday.png')}}"
																			alt="Break Dance">
																	</div>
																	<div class="timetable-item-main">
																		<div class="row">
																			<div class="col-md-6">
																				<label>@lang('Form')</label>
																				<input type="time" name="from[]"
																					   class="form-control"
																					   value="{{$day['tuesday']->from}}">
																			</div>
																			<div class="col-md-6">
																				<label>@lang('To')</label>
																				<input type="time" name="to[]"
																					   class="form-control"
																					   value="{{$day['tuesday']->to}}">
																			</div>
																		</div>
																		<div class="form-check mt-2">
																			<input class="form-check-input"
																				   name="offday[]"
																				   type="checkbox" value="tuesday"
																				   id="flexCheckChecked" {{($day['tuesday']->off_day == 1)?'checked':''}}>
																			<label class="form-check-label"
																				   for="flexCheckChecked">
																				@lang('Whole day off')
																			</label>
																		</div>
																	</div>
																</div>
															</div>

															<!-- Schedule Item 3 -->
															<div class="col-md-6 input-box">
																<div class="timetable-item">
																	<div class="timetable-item-img">
																		<img
																			src="{{asset($themeTrue.'images/wednesday.png')}}"
																			alt="Street Dance">
																	</div>
																	<div class="timetable-item-main">
																		<div class="row">
																			<div class="col-md-6">
																				<label>@lang('Form')</label>
																				<input type="time" name="from[]"
																					   class="form-control"
																					   value="{{$day['wednesday']->from}}">
																			</div>
																			<div class="col-md-6">
																				<label>@lang('To')</label>
																				<input type="time" name="to[]"
																					   class="form-control"
																					   value="{{$day['wednesday']->to}}">
																			</div>
																		</div>
																		<div class="form-check mt-2">
																			<input class="form-check-input"
																				   name="offday[]"
																				   type="checkbox" value="wednesday"
																				   id="flexCheckChecked" {{($day['wednesday']->off_day == 1)?'checked':''}}>
																			<label class="form-check-label"
																				   for="flexCheckChecked">
																				@lang('Whole day off')
																			</label>
																		</div>
																	</div>
																</div>
															</div>

															<!-- Schedule Item 4 -->
															<div class="col-md-6 input-box">
																<div class="timetable-item">
																	<div class="timetable-item-img">
																		<img
																			src="{{asset($themeTrue.'images/thursday.png')}}"
																			alt="Yoga">
																	</div>
																	<div class="timetable-item-main">
																		<div class="row">
																			<div class="col-md-6">
																				<label>@lang('Form')</label>
																				<input type="time" name="from[]"
																					   class="form-control"
																					   value="{{$day['thursday']->from}}">
																			</div>
																			<div class="col-md-6">
																				<label>@lang('To')</label>
																				<input type="time" name="to[]"
																					   class="form-control"
																					   value="{{$day['thursday']->to}}">
																			</div>
																		</div>
																		<div class="form-check mt-2">
																			<input class="form-check-input"
																				   name="offday[]"
																				   type="checkbox" value="thursday"
																				   id="flexCheckChecked" {{($day['thursday']->off_day == 1)?'checked':''}}>
																			<label class="form-check-label"
																				   for="flexCheckChecked">
																				@lang('Whole day off')
																			</label>
																		</div>
																	</div>
																</div>
															</div>

															<!-- Schedule Item 5 -->
															<div class="col-md-6 input-box">
																<div class="timetable-item">
																	<div class="timetable-item-img">
																		<img
																			src="{{asset($themeTrue.'images/friday.png')}}"
																			alt="Stretching">
																	</div>
																	<div class="timetable-item-main">
																		<div class="row">
																			<div class="col-md-6">
																				<label>@lang('Form')</label>
																				<input type="time" name="from[]"
																					   class="form-control"
																					   value="{{$day['friday']->from}}">
																			</div>
																			<div class="col-md-6">
																				<label>@lang('To')</label>
																				<input type="time" name="to[]"
																					   class="form-control"
																					   value="{{$day['friday']->to}}">
																			</div>
																		</div>
																		<div class="form-check mt-2">
																			<input class="form-check-input"
																				   name="offday[]"
																				   type="checkbox" value="friday"
																				   id="flexCheckChecked" {{($day['friday']->off_day == 1)?'checked':''}}>
																			<label class="form-check-label"
																				   for="flexCheckChecked">
																				@lang('Whole day off')
																			</label>
																		</div>
																	</div>
																</div>
															</div>

															<!-- Schedule Item 6 -->
															<div class="col-md-6 input-box">
																<div class="timetable-item">
																	<div class="timetable-item-img">
																		<img
																			src="{{asset($themeTrue.'images/saturday.png')}}"
																			alt="Street Dance">
																	</div>
																	<div class="timetable-item-main">
																		<div class="row">
																			<div class="col-md-6">
																				<label>@lang('Form')</label>
																				<input type="time" name="from[]"
																					   class="form-control"
																					   value="{{$day['saturday']->from}}">
																			</div>
																			<div class="col-md-6">
																				<label>@lang('To')</label>
																				<input type="time" name="to[]"
																					   class="form-control"
																					   value="{{$day['saturday']->to}}">
																			</div>
																		</div>
																		<div class="form-check mt-2">
																			<input class="form-check-input"
																				   name="offday[]"
																				   type="checkbox" value="saturday"
																				   id="flexCheckChecked" {{($day['saturday']->off_day == 1)?'checked':''}}>
																			<label class="form-check-label"
																				   for="flexCheckChecked">
																				@lang('Whole day off')
																			</label>
																		</div>
																	</div>
																</div>
															</div>
															<div class="col-md-6 input-box">
																<div class="timetable-item">
																	<div class="timetable-item-img">
																		<img
																			src="{{asset($themeTrue.'images/sunday.png')}}"
																			alt="Street Dance">
																	</div>
																	<div class="timetable-item-main">
																		<div class="row">
																			<div class="col-md-6">
																				<label>@lang('Form')</label>
																				<input type="time" name="from[]"
																					   class="form-control"
																					   value="{{$day['sunday']->from}}">
																			</div>
																			<div class="col-md-6">
																				<label>@lang('To')</label>
																				<input type="time" name="to[]"
																					   class="form-control"
																					   value="{{$day['sunday']->to}}">
																			</div>
																		</div>
																		<div class="form-check mt-2">
																			<input class="form-check-input"
																				   name="offday[]"
																				   type="checkbox" value="sunday"
																				   id="flexCheckChecked" {{($day['sunday']->off_day == 1)?'checked':''}}>
																			<label class="form-check-label"
																				   for="flexCheckChecked">
																				@lang('Whole day off')
																			</label>
																		</div>
																	</div>
																</div>
															</div>
														</div>
													</div>
												</div>
												<button type="submit" class="btn-custom mt-3">@lang('Save Changes')</button>
											</form>
										</div>
									</div>
								</div>
							</div>
						</div>
					</section>
				@endif
			</div>
		</div>
	</div>
@endsection
{{--@push('css-lib')--}}
{{--	<link href="https://maxcdn.bootstrapcdn.com/font-awesome/4.3.0/css/font-awesome.min.css" rel="stylesheet">--}}
{{--@endpush--}}
@push('script')
	@if ($errors->any())
		@php
			$collection = collect($errors->all());
			$errors = $collection->unique();
		@endphp
		<script>
			"use strict";
			@foreach ($errors as $error)
			Notiflix.Notify.failure("{{trans($error)}}");
			@endforeach
		</script>
	@endif
@endpush
