@extends(template().'layouts.user')
@section('page_title',__('Coupon List'))

@section('content')
	<div>
		<div class="container-fluid">
			<div class="main row">
				<div class="col-12">
					<div class="dashboard-heading">
						<h2 class="mb-0">@lang('Coupon List')</h2>
                        <div>
                            <a href="{{route('user.store.coupon.create')}}"
                               class="btn-custom customButton"><i class="fal fa-plus"></i>@lang('Create')</a>
                            <button type="button" class="btn-custom customButton" id="customOffcanvasBtn"><i class="fal fa-filter"></i>@lang('Filter')</button>
                        </div>
					</div>
					<div class="table-parent table-responsive">
						<table class="table table-striped">
							<thead>
							<tr>
								<th scope="col">@lang('SL.')</th>
								<th scope="col">@lang('Store')</th>
								<th scope="col">@lang('Code')</th>
								<th scope="col">@lang('Min Orders')</th>
								<th scope="col">@lang('Discount')</th>
								<th scope="col">@lang('Date (Start - End)')</th>
								<th scope="col">@lang('Status')</th>
								<th scope="col">@lang('Action')</th>
							</tr>
							</thead>
							<tbody>
							@forelse($coupons as $key => $item)
								<tr>
									<td data-label="@lang('SL.')">{{++$key}}</td>
									<td data-label="@lang('Store')">{{ optional($item->store)->name }}</td>
									<td data-label="@lang('Code')"><span
											class="badge2">{{ $item->code }}</span></td>
									<td data-label="@lang('Min Orders')">{{ currencyPosition(getAmount($item->min_order)) }}</td>
									<td data-label="@lang('Discount')"><span
											class="text-danger">{{ $item->discount_amount }}
											@if($item->discount_type == 'flat')
												{{ basicControl()->base_currency }}
											@else
                                                %
											@endif
										</span>
									</td>
									<td data-label="@lang('Date (Start - End)')">{{ dateTime($item->start_date) }}
										- {{ dateTime($item->end_date) }}</td>
									<td data-label="@lang('Status')">
										@if($item->status == 1 && $item->end_date > \Carbon\Carbon::now())
											<span class="badge bg-success">@lang('Active')</span>
										@elseif($item->status == 0 && $item->end_date > \Carbon\Carbon::now())
											<span class="badge bg-warning">@lang('Inactive')</span>
										@else
											<span class="badge bg-danger">@lang('Expired')</span>
										@endif
									</td>
									<td data-label="Action">
										<div class="sidebar-dropdown-items">
											<button
												type="button"
												class="dropdown-toggle customButton"
												data-bs-toggle="dropdown"
												aria-expanded="false">
												<i class="fal fa-cog"></i>
											</button>
											<ul class="dropdown-menu dropdown-menu-end">
												<li>
													<a href="{{route('user.store.coupon.edit',$item->id)}}"
													   class="dropdown-item"> <i
															class="fal fa-edit"></i> @lang('Edit') </a>
												</li>
												<li>
													<button class="dropdown-item deleteCoupon" type="button"
															data-bs-target="#couponDelete"
															data-bs-toggle="modal"
															data-route="{{route('user.store.coupon.delete',$item->id)}}">
														<i class="fal fa-trash text-danger"></i> @lang('Delete')
													</button>
												</li>
											</ul>
										</div>
									</td>
								</tr>
							@empty
                                <tr class="text-center">
                                    <th class="text-center" colspan="100%">
                                        <img class="noDataImg" src="{{ asset('assets/admin/img/oc-error-light.svg') }}" alt="image">
                                        <p class="mt-3">@lang('No data available')</p>
                                    </th>
                                </tr>
							@endforelse
							</tbody>
						</table>
					</div>
					<nav aria-label="Page navigation example">
						<ul class="pagination justify-content-center">
                            {{ $coupons->appends($_GET)->links(template().'partials.pagination') }}
						</ul>
					</nav>
				</div>
			</div>
		</div>
	</div>
	<div class="modal fade" id="couponDelete" tabindex="-1" aria-labelledby="couponDelete" aria-hidden="true">
		<div class="modal-dialog modal-dialog-top modal-md">
			<div class="modal-content">
				<div class="modal-header">
					<h5 class="modal-title" id="categoryDelete">@lang('Delete Confirmation')</h5>
					<button type="button" class="close-btn" data-bs-dismiss="modal" aria-label="Close">
						<i class="fal fa-times"></i>
					</button>
				</div>
				<div class="modal-body">
					<div class="row g-4">
						<p>@lang('Are you want to delete this coupon?')</p>
					</div>
				</div>
				<div class="modal-footer">
					<form action="" method="post" class="deleteCouponForm">
						@csrf
						@method('delete')
						<button type="button" class="btn-custom btn2" data-bs-dismiss="modal">@lang('Close')</button>
						<button type="submit" class="btn-custom">@lang('Yes')</button>
					</form>
				</div>
			</div>
		</div>
	</div>

    <div class="custom-offcanvas end ">
        <div class="custom-offcanvas-header">
            <h4 class="custom-offcanvas-title mb-0">@lang('Filter')</h4>
            <button type="button" class="cmn-btn-close" data-bs-dismiss="offcanvas" aria-label="Close">
                <i class="fas fa-times"></i>
            </button>
        </div>
        <div class="custom-offcanvas-body">
            <div class="search-bar canvas_input_box">
                <form action="" method="get">
                    <div class="row g-3 align-items-end">
                        <div class="input-box col-lg-12">
                            <label>@lang('Store Name')</label>
                            <input placeholder="@lang('Store Name')" name="store_name" value="{{ @request()->store_name }}" type="text"
                                   class="form-control form-control-sm">
                        </div>
                        <div class="input-box col-lg-12">
                            <label>@lang('Code')</label>
                            <input placeholder="@lang('Code')" name="code" value="{{ @request()->code }}" type="text"
                                   class="form-control form-control-sm">
                        </div>
                        <div class="input-box col-lg-12">
                            <label>@lang('Min Orders')</label>
                            <input placeholder="@lang('Min Orders')" name="min_orders" value="{{ @request()->min_orders }}" type="text"
                                   class="form-control form-control-sm">
                        </div>
                        <div class="input-box col-lg-12">
                            <label>@lang('Start Date')</label>
                            <input name="start_date"
                                   value="{{ @request()->start_date }}" type="date" class="form-control form-control-sm"
                                   autocomplete="off">
                        </div>
                        <div class="input-box col-lg-12">
                            <label>@lang('End Date')</label>
                            <input name="end_date"
                                   value="{{ @request()->end_date }}" type="date" class="form-control form-control-sm"
                                   autocomplete="off">
                        </div>
                        <div class="input-box col-lg-12">
                            <label>@lang('Status')</label>
                            <div class="form-group">
                                <select name="status" class="form-select" aria-label="Default select example">
                                    <option value="">@lang('All Status')</option>
                                    <option
                                        value="active" {{ @request()->status == 'active' ? 'selected' : '' }}>@lang('Active')</option>
                                    <option
                                        value="inactive" {{ @request()->status == 'inactive' ? 'selected' : '' }}>@lang('Inactive')</option>
                                    <option
                                        value="expired" {{ @request()->status == 'expired' ? 'selected' : '' }}>@lang('Expired')</option>
                                </select>
                            </div>
                        </div>
                        <div class="input-box col-lg-12">
                            <button type="submit" class="btn-custom w-100"><i class="fal fa-search"></i> @lang('Filter')</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
@push('script')
	<script>
		'use strict'
		$(document).on('click', '.deleteCoupon', function () {
			var route = $(this).data('route');
			$('.deleteCouponForm').attr('action', route);
		})

		$(document).ready(function () {
			$('[data-toggle="tooltip"]').tooltip();
		});

	</script>
	@if ($errors->any())
		@php
			$collection = collect($errors->all());
			$errors = $collection->unique();
		@endphp
		<script>
			"use strict";
			@foreach ($errors as $error)
			Notiflix.Notify.failure("{{trans($error)}}");
			@endforeach
		</script>
	@endif
@endpush
