@extends(template().'layouts.user')
@section('page_title',__('Category List'))

@section('content')
	<div id="category" v-cloak>
		<div class="container-fluid">
			<div class="main row">
				<div class="col-12">
					<div class="dashboard-heading">
						<h2 class="mb-0">@lang('Food Category')</h2>
                        <div>
                            <a href="javascript:void(0)" data-bs-target="#addCategory" @click="makeEmpty" data-bs-toggle="modal" class="btn-custom customButton"><i class="fal fa-plus"></i>@lang('Create')</a>
                            <button type="button" class="btn-custom customButton" id="customOffcanvasBtn"><i class="fal fa-filter"></i>@lang('Filter')</button>
                        </div>
					</div>

					<div class="table-parent table-responsive">
						<table class="table table-striped">
							<thead>
							<tr>
								<th scope="col">@lang('SL.')</th>
								<th scope="col">@lang('Name')</th>
								<th scope="col">@lang('Active Menu')</th>
								<th scope="col">@lang('Status')</th>
								<th scope="col">@lang('Action')</th>
							</tr>
							</thead>
							<tbody>
							@forelse($categories as $key => $item)
								<tr>
									<td data-label="@lang('SL.')">{{++$key}}</td>
									<td data-label="@lang('Name')">{{ $item->name }}</td>
									<td data-label="@lang('Active Menu')">
										<span class="badge2">{{ $item->active_products_count }}</span>
									</td>
									<td data-label="@lang('Status')">
										@if($item->status == 1)
											<span
												class="badge bg-success">@lang('Active')</span>
										@else
											<span
												class="badge bg-warning">@lang('Inactive')</span>
										@endif
									</td>
									<td data-label="Action">
										<div class="sidebar-dropdown-items">
											<button
												type="button"
												class="dropdown-toggle customButton"
												data-bs-toggle="dropdown"
												aria-expanded="false">
												<i class="fal fa-cog"></i>
											</button>
											<ul class="dropdown-menu dropdown-menu-end">
												<li>
													<a href="javascript:void(0)" class="dropdown-item"
													   @click="edit({{$item}})"
													   data-bs-target="#editCategory"
													   data-bs-toggle="modal"> <i
															class="fal fa-edit"></i> @lang('Edit') </a>
												</li>
												<li>
													<button class="dropdown-item deleteCategory" type="button"
															data-bs-target="#categoryDelete"
															data-bs-toggle="modal"
															data-route="{{route('user.store.category.delete',$item->id)}}">
														<i class="fal fa-trash text-danger"></i> @lang('Delete')
													</button>
												</li>
											</ul>
										</div>
									</td>
								</tr>
							@empty
                                <tr class="text-center">
                                    <th class="text-center" colspan="100%">
                                        <img class="noDataImg" src="{{ asset('assets/admin/img/oc-error-light.svg') }}" alt="image">
                                        <p class="mt-3">@lang('No data available')</p>
                                    </th>
                                </tr>
							@endforelse
							</tbody>
						</table>
					</div>
					<nav aria-label="Page navigation example">
						<ul class="pagination justify-content-center">
							{{ $categories->appends($_GET)->links(template().'partials.pagination') }}
						</ul>
					</nav>
				</div>
			</div>
		</div>
		@include(template().'user.store.category.modal')
	</div>

    <div class="custom-offcanvas end ">
        <div class="custom-offcanvas-header">
            <h4 class="custom-offcanvas-title mb-0">@lang('Filter')</h4>
            <button type="button" class="cmn-btn-close" data-bs-dismiss="offcanvas" aria-label="Close">
                <i class="fas fa-times"></i>
            </button>
        </div>
        <div class="custom-offcanvas-body">
            <div class="search-bar canvas_input_box">
                <form action="" method="get">
                    <div class="row g-3 align-items-end">
                        <div class="input-box col-lg-12">
                            <input placeholder="@lang('Category Name')" name="name" value="{{ request()->name ?? '' }}" type="text"
                                   class="form-control form-control-sm">
                        </div>
                        <div class="input-box col-lg-12">
                            <input placeholder="@lang('Date')" name="created_at" id="created_at"
                                   value="{{ request()->created_at ?? '' }}" type="date" class="form-control form-control-sm"
                                   autocomplete="off">
                        </div>
                        <div class="input-box col-lg-12">
                            <div class="form-group search-currency-dropdown">
                                <select name="status" class="form-select" aria-label="Default select example">
                                    <option value="">@lang('All Status')</option>
                                    <option  value="1" {{ isset(request()->status) && request()->status == 1 ? 'selected' : '' }}>@lang('Active')</option>
                                    <option  value="0" {{ isset(request()->status) && request()->status == 0 ? 'selected' : '' }}>@lang('Inactive')</option>
                                </select>
                            </div>
                        </div>
                        <div class="input-box col-lg-12">
                            <button type="submit" class="btn-custom  w-100"><i class="fal fa-search"></i> @lang('Filter')</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
@push('script')
	<script>
		'use strict'
		var newApp = new Vue({
			el: "#category",
			data: {
				item: {
					name: "", status: "", id: ""
				},
			},
			mounted() {
				this.item.status = 1;
			},
			methods: {
				save() {
					axios.post("{{ route('user.store.category.store') }}", this.item)
						.then(function (response) {
							if (response.data.status == 'success') {
								window.location.href = response.data.url;
							}
						})
						.catch(function (error) {
							let errors = error.response.data;
							errors = errors.errors
							for (let err in errors) {
								let selector = document.querySelector("." + err);
								if (selector) {
									selector.innerText = `${errors[err]}`;
								}
							}
						});
				},
				edit(obj) {
					this.item.name = obj.name;
					this.item.id = obj.id;
					this.item.status = obj.status;
				},
				update() {
					axios.post("{{ route('user.store.category.update') }}", this.item)
						.then(function (response) {
							if (response.data.status == 'success') {
								window.location.href = response.data.url;
							}
						})
						.catch(function (error) {
							let errors = error.response.data;
							errors = errors.errors
							for (let err in errors) {
								let selector = document.querySelector("." + err);
								if (selector) {
									Notiflix.Notify.failure(`${errors[err]}`);
								}
							}
						});
				},
				makeEmpty() {
					this.item.name = "";
					this.item.status = 1;
					$('.text-danger').text('');
				}
			},
		})

		$(document).on('click', '.deleteCategory', function () {
			var route = $(this).data('route');
			$('.deleteCategoryForm').attr('action', route);
		})

		$(document).ready(function () {
			$('[data-toggle="tooltip"]').tooltip();
		});

	</script>
	@if ($errors->any())
		@php
			$collection = collect($errors->all());
			$errors = $collection->unique();
		@endphp
		<script>
			"use strict";
			@foreach ($errors as $error)
			Notiflix.Notify.failure("{{trans($error)}}");
			@endforeach
		</script>
	@endif
@endpush
