@extends(template().'layouts.user')
@section('page_title',__('Messenger Bot'))

@section('content')
	<div class="container-fluid">
		<div class="main row">
			<div class="col-md-8">
				<div class="dashboard-heading">
					<h2 class="mb-0">@lang('Messenger Bot')</h2>
				</div>
				<section class="profile-setting">
					<div class="sidebar-wrapper">
						<form action="{{route('user.store.messenger.set',$store->id)}}" method="post" enctype="multipart/form-data">
							@csrf
							<div class="row">
								<div class="col-md-12">
									<div class="input-box form-group">
										<label for="Token">@lang('Facebook Token')</label>
										<input type="text"
											   name="messenger_token"
											   value="{{old('messenger_token')??$store->messenger_token}}"
											   placeholder="EAAB5L1f3Rw0BAPlmGtzcvqTY3aH8CPVPhrlNZAi7yhgcCb0ZB43mTq1k0hWnQ5Imd0LTOcOjzfxWWBY9KnnGEN5V4Y1eTb1SXuVGHZAqykX26OjCiaM83Jd3yIkZB827VcXxv1tDZBmEOYb3alhvSsq7uHmgcdDjdC8IkisD9mKkR8vmcSlFNjoZBRq6084KcZD"
											   class="form-control"
											   autocomplete="off" required>
										<div class="text-danger">
											@error('messenger_token') @lang($message) @enderror
										</div>

									</div>
								</div>
							</div>
							<div class="row mt-3">
								<div class="col-md-6">
									<div class="input-box form-group">
										<label for="Token">@lang('Callback URL')</label>
										<div class="input-group">
											<input type="text"
												   value="{{route('messengerWebhook',$store->link)}}"
												   class="form-control"
												   id="webhook"
												   autocomplete="off" readonly>
											<button type="button" onclick="webhookCopy()"
													class="btn-modify">@lang('copy')</button>
										</div>
									</div>
								</div>
								<div class="col-md-6">
									<div class="input-box form-group">
										<label for="Verify token">@lang('Verify token')</label>
										<div class="input-group">
											<input type="text"
												   value="{{$store->link}}"
												   class="form-control"
												   id="verify_token"
												   autocomplete="off" readonly>
											<button type="button" onclick="verify_token_copy()"
													class="btn-modify">@lang('copy')</button>
										</div>
									</div>
								</div>
							</div>
							<div class="row mt-3">
								<div class="col-sm-12 col-md-4 input-box">
									<label>@lang('Initiate Image')</label>
									<div class="form-group position-relative">
										<div class="image-input z0">
											<label for="image-upload" id="image-label"><i
													class="fas fa-upload"></i></label>
											<input type="file" id="image" name="messenger_bot_image"
												   placeholder="@lang('Choose image')" class="image-preview">
											<img id="image_preview_container" class="preview-image"
												 src="{{ getFile($store->messenger_bot_image_driver,$store->messenger_bot_image) }}"
												 alt="@lang('preview image')">
										</div>
									</div>
									<div class="text-danger">
										@error('messenger_bot_image') @lang($message) @enderror
									</div>

									@if(config("filelocation.messengerBot"))
										<span class="text-warning">{{trans('Image size should be')}} {{config("filelocation.messengerBot.size")}} {{trans('px')}}</span>
									@endif
								</div>
							</div>
							<div class="row mt-3">
								<div class="col-md-12">
									<div class="input-box form-group">
										<label
											for="Initiate Message">@lang('Initiate Message')</label>
										<textarea name="messenger_initiate_message" rows="5"
												  placeholder="@lang('Welcome please open menu and order food.')"
												  class="form-control form-control-sm" required>{{old('messenger_initiate_message')??$store->messenger_initiate_message}}</textarea>
										<div class="text-danger">
											@error('messenger_initiate_message') @lang($message) @enderror
										</div>
									</div>
								</div>
							</div>

							<button type="submit" class="btn-custom mt-3">@lang('Create Bot')</button>
						</form>
					</div>
				</section>
			</div>
			<div class="col-md-4 mt-5">
				<section class="profile-setting">
					<div class="sidebar-wrapper">
							<div class="row">
								<div class="col-md-12">
									<div class="d-flex justify-content-between">
										<h5>@lang('Instructions')</h5>
										<a href="{{route('user.store.messenger.docs')}}" target="_blank" class="btn-modify">@lang('How to set up')</a>
									</div>
								</div>
								<p class="mt-4">
									@lang('Curious to learn how to set up our bot quickly and effortlessly? Click the "How to Set Up" button below to access our comprehensive guide. Inside,')
									@lang("you'll find step-by-step instructions, screenshots, and tips to guide you through the setup process. Don't miss out on this valuable resource – get started now and unleash the full potential of our bot in no time!")
								</p>
							</div>
					</div>
				</section>
			</div>
		</div>
	</div>
@endsection

@push('script')
	<script>
		'use strict';

		$(document).on('change', '.image-preview', function () {
			let reader = new FileReader();
			reader.onload = (e) => {
				$('#image_preview_container').attr('src', e.target.result);
			}
			reader.readAsDataURL(this.files[0]);
		});

		function webhookCopy() {
			var copyText = document.getElementById("webhook");
			copyText.select();
			copyText.setSelectionRange(0, 99999);
			navigator.clipboard.writeText(copyText.value);
			Notiflix.Notify.success(`${copyText.value} Copied`);
		}

		function verify_token_copy() {
			var copyText = document.getElementById("verify_token");
			copyText.select();
			copyText.setSelectionRange(0, 99999);
			navigator.clipboard.writeText(copyText.value);
			Notiflix.Notify.success(`${copyText.value} Copied`);
		}
	</script>
	@if ($errors->any())
		@php
			$collection = collect($errors->all());
			$errors = $collection->unique();
		@endphp
		<script>
			"use strict";
			@foreach ($errors as $error)
			Notiflix.Notify.failure("{{trans($error)}}");
			@endforeach
		</script>
	@endif
@endpush

