@extends(template().'layouts.user')
@section('page_title',__('Command Templates'))

@section('content')
	<div class="container-fluid">
		<div class="main row">
			<div class="col-12">
				<div class="dashboard-heading">
					<h2 class="mb-0">@lang('Command Templates')</h2>
				</div>
				<div class="identity-confirmation">
					<form role="form">
						<div class="row g-4">
							<table class="table table-striped table-hover align-items-center table-flush"
								   id="data-table">
								<thead>
								<tr>
									<th>@lang('Command List')</th>
									<th>@lang('Description')</th>
									<th>@lang('Action')</th>
								</tr>
								</thead>
								<tbody>
								<tr>
									<td data-label="@lang('Command List')" class="text-lowercase">
										/menu
									</td>
									<td data-label="@lang('Description')">
										@lang('To start the webpage and orders unlimited foods')
									</td>
									<td></td>
								</tr>
								<tr>
									<td data-label="@lang('Command List')" class="text-lowercase">
										/help
									</td>
									<td data-label="@lang('Description')">
										@lang('To get all types of command list')
									</td>
									<td></td>
								</tr>
								@if($store->bot_command)
									@forelse($store->bot_command as $key => $item)
										<tr>
										    @if($key == 'orderconfirm')
										    <td data-label="@lang('Command List')" class="text-lowercase">
												{{$key}}
											</td>
										    @else
											<td data-label="@lang('Command List')" class="text-lowercase">
												/{{$key}}
											</td>
											@endif
											<td data-label="@lang('Description')">
												{{$item->description}}
											</td>
											<td data-label="Action">
												<div class="sidebar-dropdown-items">
													<button
														type="button"
														class="dropdown-toggle"
														data-bs-toggle="dropdown"
														aria-expanded="false">
														<i class="fal fa-cog"></i>
													</button>
													<ul class="dropdown-menu dropdown-menu-end">
														<li>
															<a href="{{route('user.store.command.edit',[$store->id,$key])}}"
															   class="dropdown-item"> <i class="fa fa-edit"></i> @lang('Edit') </a>
														</li>
													</ul>
												</div>
											</td>
										</tr>
									@empty
									@endforelse
								@endif
								</tbody>
							</table>
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
@endsection

