@extends(template().'layouts.user')
@section('page_title',__('Dashboard'))

@push('css-lib')
    <link rel="stylesheet" type="text/css" href="{{ asset($themeTrue.'/css/daterangepicker.css') }}"/>
@endpush

@section('content')
    <!-- main -->
    <div class="container-fluid">
        <div class="main row">
            <div class="col-12">
                <div class="dashboard-heading">
                    <h2 class="mb-0">@lang('Dashboard')</h2>
                </div>
                <div class="dashboard-box-wrapper">
                    <div class="row g-4 mb-4">
                        <div class="col-xl-4 col-md-4 box">
                            <div class="dashboard-box">
                                <h5>@lang('Remaining Stores')</h5>
                                <h3>{{$remainingStores}}</h3>
                                <i class="fal fa-store"></i>
                            </div>
                        </div>
                        <div class="col-xl-4 col-md-4 box">
                            <div class="dashboard-box">
                                <h5>@lang('Remaining Menu')</h5>
                                <h3>{{$remainingMenus}}</h3>
                                <i class="fal fa-cutlery"></i>
                            </div>
                        </div>
                        <div class="col-xl-4 col-md-4 box">
                            <div class="dashboard-box">
                                <h5>@lang('Remaining Orders')</h5>
                                <h3>{{$remainingOrders}}</h3>
                                <i class="fal fa-tags"></i>
                            </div>
                        </div>
                    </div>
                    <div class="row g-4 mb-4">
                        <div class="col-xl-3 col-md-6 box">
                            <div class="dashboard-box">
                                <h5>@lang('Active Stores')</h5>
                                <h3>{{$store['ActiveStores']}}</h3>
                                <i class="fal fa-store"></i>
                            </div>
                        </div>
                        <div class="col-xl-3 col-md-6 box">
                            <div class="dashboard-box">
                                <h5>@lang('Active Menu')</h5>
                                <h3>{{$menu['ActiveMenu']}}</h3>
                                <i class="fal fa-cutlery"></i>
                            </div>
                        </div>
                        <div class="col-xl-3 col-md-6 box">
                            <div class="dashboard-box">
                                <h5>@lang('Total Orders')</h5>
                                <h3>{{$order['TotalOrders']}}</h3>
                                <i class="fal fa-tags"></i>
                            </div>
                        </div>
                        <div class="col-xl-3 col-md-6 box">
                            <div class="dashboard-box">
                                <h5>@lang('Remaining Days')</h5>
                                <h3>{{\Carbon\Carbon::now()->diff($user->expiry_date)->format("%a")}}</h3>
                                <i class="fal fa-history"></i>
                            </div>
                        </div>
                    </div>
                </div>


            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="card mb-4 shadow-sm">
                        <div class="card-body">
                            <div class="d-flex justify-content-between flex-wrap">
                                <h5 class="card-title">@lang('Transaction Summary')</h5>
                                <input type="button" class="btn btn-sm btn-base-color" name="daterange" value=""/>
                            </div>
                            <div>
                                <canvas id="line-chart" height="120"></canvas>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="card mb-4 shadow-sm">
                        <div class="card-body">
                            <h5 class="card-title">@lang('Order Statistics')</h5>
                            <div>
                                <canvas id="line-chart-2" height="120"></canvas>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('js-lib')
    <script src="{{ asset($themeTrue.'/js/chart.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset($themeTrue.'/js/moment.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset($themeTrue.'/js/daterangepicker.min.js') }}"></script>
@endpush

@push('script')
    <script>
        'use strict';
        $(document).ready(function () {
            $('input[name="daterange"]').daterangepicker({
                opens: 'left',
                startDate: moment().startOf('month'),
                endDate: moment().endOf('month'),
                locale: {
                    format: 'MMMM D, YYYY'
                }
            }, function (start, end) {
                getTransaction(start.format('YYYY-MM-DD'), end.format('YYYY-MM-DD'));
            });

            function getTransaction(start, end) {
                $.ajax({
                    method: "GET",
                    url: "{{ route('user.get.transaction.chart') }}",
                    dataType: "json",
                    data: {
                        'start': start,
                        'end': end,
                    }
                })
                    .done(function (response) {
                        new Chart(document.getElementById("line-chart"), {
                            type: 'line',
                            data: {
                                labels: response.labels,
                                datasets: [

                                    {
                                        data: response.dataPurchasePlan,
                                        label: "Purchase Plan",
                                        borderColor: "#00cec9",
                                        fill: false
                                    },

                                    {
                                        data: response.dataOrder,
                                        label: "Order",
                                        borderColor: "#feba27",
                                        fill: false
                                    },
                                ]
                            }
                        });
                    });
            }

            new Chart(document.getElementById("line-chart"), {
                type: 'line',
                data: {
                    labels: {!! json_encode($labels) !!},
                    datasets: [

                        {
                            data: {!! json_encode($dataPurchasePlan) !!},
                            label: "Purchase Plan",
                            borderColor: "#00cec9",
                            fill: false
                        },

                        {
                            data: {!! json_encode($dataOrder) !!},
                            label: "Order",
                            borderColor: "#feba27",
                            fill: false
                        },
                    ]
                }
            });

            new Chart(document.getElementById("line-chart-2"), {
                type: 'bar',
                data: {
                    labels: {!! json_encode($yearLabels) !!},
                    datasets: [
                        {
                            data: {!! json_encode($yearPendingOrders) !!},
                            label: "Pending Orders",
                            borderColor: "#e67e22",
                            backgroundColor: "#e67e22",
                        },

                        {
                            data: {!! json_encode($yearCancelOrders) !!},
                            label: "Cancel Orders",
                            borderColor: "#e52719",
                            backgroundColor: "#e52719",
                        },
                        {
                            data: {!! json_encode($yearCompleteOrders) !!},
                            label: "Completed Orders",
                            borderColor: "#1abc9c",
                            backgroundColor: "#1abc9c",
                        },
                    ]
                }
            });

        });
    </script>
@endpush
