
@if(!empty($how_it_work))
    <section class="working-process">
        <div class="container">
            @if(!empty($how_it_work['single']))
                <div class="row">
                    <div class="col-12">
                        <div class="header-text text-center">
                            <h5>@lang($how_it_work['single']['heading'] ?? '')</h5>
                            <h2>@lang($how_it_work['single']['title'] ?? '')</h2>
                            <p class="mx-auto">@lang($how_it_work['single']['sub_title'] ?? '')</p>
                        </div>
                    </div>
                </div>
            @endif
            <div class="row align-items-center">
                <div class="col-lg-6">
                    @foreach($how_it_work['multiple'] as $item)
                        <div class="process-box">
                            <div class="icon-box">
                                <i class="fa-duotone fa-circle-check"></i>
                            </div>
                            <div class="text-box">
                                <h4>@lang($item['title'] ?? '')</h4>
                                <p>
                                    @lang($item['description'] ?? '')
                                </p>
                            </div>
                        </div>
                    @endforeach
                </div>
                @if(!empty($how_it_work['single']['media']))
                    <div class="col-lg-6">
                        <div class="img-box">
                            <img src="{{asset($themeTrue.'images/mobile.png')}}" class="img-1" alt="..."/>
                            <video id="videoContent" width="198" autoplay muted controls playsinline>
                                <source id="videoSource" src="{{ getFile($how_it_work['single']['media']->video->driver, $how_it_work['single']['media']->video->path) }}" type="video/mp4"/>
                            </video>
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </section>
@endif

