<!DOCTYPE html>
<html lang="en" @if(session()->get('rtl') == 1) dir="rtl" @endif />
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link href="{{ getFile(basicControl()->favicon_driver, basicControl()->favicon) }}" rel="icon">
	<title> @lang("Whatsapp Configuration") | {{basicControl()->site_title}} </title>

    <meta name="csrf-token" content="{{ csrf_token() }}">
    <link rel="stylesheet" href="{{ asset($themeTrue . 'css/bootstrap.min.css')}}"/>

    <link rel="stylesheet" href="{{ asset($themeTrue . 'css/all.min.css')}}"/>
    <link rel="stylesheet" href="{{ asset($themeTrue . 'css/fontawesome.min.css')}}"/>
    <link rel="stylesheet" href="{{ asset($themeTrue . 'css/animate.css')}}"/>
    <link rel="stylesheet" href="{{ asset($themeTrue . 'css/owl.carousel.min.css')}}"/>
    <link rel="stylesheet" href="{{ asset($themeTrue . 'css/owl.theme.default.min.css')}}"/>
    <link rel="stylesheet" href="{{ asset($themeTrue . 'css/style.css')}}"/>
    @stack('css-lib')
    @stack('style')
</head>

<body>

<div id="app">
	<div class="dashboard-wrapper">
		<!-- sidebar -->
		<div id="sidebar" class="">
			<div class="sidebar-top">
                <a class="navbar-brand" href="{{url('/')}}"> <img
                        src="{{ getFile(basicControl()->logo_driver, basicControl()->logo) }}"
                        alt="{{ basicControl()->site_title }}"/></a>
				<button class="sidebar-toggler d-md-none" onclick="toggleSideMenu()">
					<i class="fal fa-times"></i>
				</button>
			</div>
			<ul class="main">
				<li>
					<a class="{{menuActive('user.store.list')}}" href="{{route('user.store.list')}}"><i
							class="fal fa-arrow-left"></i>@lang("Back")</a>
				</li>

				<li>
					<a class="" href="#Create_a_Telegram_account">
						<i class="fab fa-telegram"></i>@lang("Create a Twilio account")</a>
				</li>

				<li>
					<a class="" href="#Create_a_new_bot">
						<i class="fa fa-rocket-launch"></i>@lang("Obtain Credentials")</a>
				</li>
				<li>
					<a class="" href="#Set_up_the_bot">
						<i class="fa fa-rocket-launch"></i>@lang("Configuring Inbound Message Webhooks")</a>
				</li>
			</ul>
		</div>


		<!-- content -->
		<div id="content">
			<div class="overlay">
				@include($theme.'partials.user.topbar')

				<div class="container-fluid">
					<div class="main row doc-content">
						<div class="col-12">
							<div id="Create_a_Telegram_account" class="padding">
								<h4 class="mt-3">@lang("Create a Twilio account")</h4>
								<ul>
									<li>@lang("Sign up for a Twilio account at")
										<a href="https://www.twilio.com/"
										   target="_blank">https://www.twilio.com/</a> @lang("if you haven't already.")
									</li>
									<li>@lang("Verify your phone number as instructed during the account setup process.")</li>
									<li>@lang("Upgrade your Twilio account to a paid plan with WhatsApp capabilities.")</li>
									<li>@lang("Request access to the WhatsApp Business API by following Twilio's documentation.")
										<a href="https://www.twilio.com/whatsapp/request-access" target="_blank">https://www.twilio.com/whatsapp/request-access</a>
									</li>
								</ul>
							</div>

							<div id="Create_a_new_bot" class="padding">
								<h4 class="mt-3">@lang('Obtain Credentials')</h4>
								<ul>
									<li>@lang("Once approved, Twilio will provide you with a WhatsApp Business API client account.")</li>
									<li>
										@lang('Obtain your Account SID and Auth Token from the Twilio Console.') <a
											href="https://www.twilio.com/console">https://www.twilio.com/console</a> @lang('under your account settings.')

										<br>
										<br>
										<div class="code-block ">
											<img src="{{asset($themeTrue.'images/whatsapp/1.png')}}" class="w-50"
												 alt="">
										</div>
										<br>
									</li>
									<li>
										@lang('Whatsapp Enabled Senders.')

										<br>
										<br>
										<div class="code-block ">
											<img src="{{asset($themeTrue.'images/whatsapp/2.png')}}" class="w-50"
												 alt="">
										</div>
										<br>
									</li>
									<li>@lang("Once your number has been enabled for WhatsApp, it can be used as a WhatsApp Sender. Clicking on a specific Sender takes you to its specific Configuration page. This includes the Endpoint configuration section, where you can specify what action Twilio should take when it receives a WhatsApp message at this number. You can also update all your profile details here.")
										<br>
										<br>
										<div class="code-block ">
											<img src="{{asset($themeTrue.'images/whatsapp/3.png')}}" class="w-50"
												 alt="">
										</div>
										<br>
									</li>
								</ul>
							</div>

							<div id="Set_up_the_bot" class="padding">
								<h4 class="mt-3">@lang("Configuring Inbound Message Webhooks")</h4>
								<ul>
									<li>
										@lang('When customers send you a WhatsApp message, Twilio sends a webhook (a request to a URL that you specify) to your application. You can configure the URL to which Twilio sends a webhook when it receives inbound messages in the Twilio Console.')
										<br>
										<div class="code-block ">
											<img src="{{asset($themeTrue.'images/whatsapp/5.png')}}" class="w-50"
												 alt="">
										</div>
										<br>
										<div class="code-block ">
											<img src="{{asset($themeTrue.'images/whatsapp/4.png')}}" class="w-50"
												 alt="">
										</div>
									</li>
								</ul>
							</div>
							<p>
								@lang("Your Whatsapp bot is now set up and ready to provide its intended functionality. Remember to monitor the bot's performance, address any issues or user feedback promptly, and continue enhancing the bot's features to improve the user experience.")
							</p>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<script src="{{ asset($themeTrue . 'js/bootstrap.bundle.min.js')}}"></script>
<script src="{{ asset($themeTrue . 'js/jquery.min.js')}}"></script>
<script src="{{ asset($themeTrue . 'js/owl.carousel.min.js')}}"></script>
<script src="{{ asset($themeTrue . 'js/qrjs2.min.js')}}"></script>
<script src="{{ asset($themeTrue . 'js/socialSharing.js')}}"></script>
<script src="{{ asset('assets/global/js/notiflix-aio-3.2.6.min.js') }}"></script>
<script src="{{ asset('assets/global/js/select2.min.js') }}"></script>
<script src="{{ asset($themeTrue . 'js/script.js')}}"></script>

<script src="{{ asset('assets/global/js/pusher.min.js') }}"></script>
<script src="{{ asset('assets/global/js/vue.min.js') }}"></script>
<script src="{{ asset('assets/global/js/axios.min.js') }}"></script>

@if(session()->has('success'))
    <script>
        Notiflix.Notify.success("@lang(session('success'))");
    </script>
@endif
@if(session()->has('error'))
    <script>
        Notiflix.Notify.failure("@lang(session('error'))");
    </script>
@endif

@stack('script')
</body>
</html>
