<!DOCTYPE html>
<html lang="en" @if(session()->get('rtl') == 1) dir="rtl" @endif />
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link href="{{ getFile(basicControl()->favicon_driver, basicControl()->favicon) }}" rel="icon">
	<title> @lang("Telegram Configuration") | {{basicControl()->site_title}} </title>

    <meta name="csrf-token" content="{{ csrf_token() }}">
    <link rel="stylesheet" href="{{ asset($themeTrue . 'css/bootstrap.min.css')}}"/>

    <link rel="stylesheet" href="{{ asset($themeTrue . 'css/all.min.css')}}"/>
    <link rel="stylesheet" href="{{ asset($themeTrue . 'css/fontawesome.min.css')}}"/>
    <link rel="stylesheet" href="{{ asset($themeTrue . 'css/animate.css')}}"/>
    <link rel="stylesheet" href="{{ asset($themeTrue . 'css/owl.carousel.min.css')}}"/>
    <link rel="stylesheet" href="{{ asset($themeTrue . 'css/owl.theme.default.min.css')}}"/>
    <link rel="stylesheet" href="{{ asset($themeTrue . 'css/style.css')}}"/>
    @stack('css-lib')
    @stack('style')
</head>

<body>

<div id="app">
	<div class="dashboard-wrapper">
		<!-- sidebar -->
		<div id="sidebar" class="">
			<div class="sidebar-top">
                <a class="navbar-brand" href="{{url('/')}}"> <img
                        src="{{ getFile(basicControl()->logo_driver, basicControl()->logo) }}"
                        alt="{{ basicControl()->site_title }}"/></a>
				<button class="sidebar-toggler d-md-none" onclick="toggleSideMenu()">
					<i class="fal fa-times"></i>
				</button>
			</div>
			<ul class="main">
				<li>
					<a class="{{menuActive('store.list')}}" href="{{route('user.store.list')}}"><i
							class="fal fa-arrow-left"></i>@lang("Back")</a>
				</li>

				<li>
					<a class="" href="#Create_a_Telegram_account">
						<i class="fab fa-telegram"></i>@lang("Create a Telegram account")</a>
				</li>

				<li>
					<a class="" href="#Create_a_new_bot">
						<i class="fa fa-rocket-launch"></i>@lang("Create a new bot")</a>
				</li>
				<li>
					<a class="" href="#Set_up_the_bot">
						<i class="fa fa-rocket-launch"></i>@lang("Set up the bot")</a>
				</li>
			</ul>
		</div>

		<!-- content -->
		<div id="content">
			<div class="overlay">
                @include(template().'partials.user.topbar')

				<div class="container-fluid">
					<div class="main row doc-content">
						<div class="col-12">
							<div id="Create_a_Telegram_account" class="padding">
								<h4 class="mt-3">@lang("Create a Telegram account")</h4>
								<ul>
									<li>@lang("If you don't already have a Telegram account, download the Telegram app on your device and sign up for an account.")</li>
								</ul>
							</div>

							<div id="Create_a_new_bot" class="padding">
								<h4 class="mt-3">@lang('Create a new bot')</h4>
								<ul>
									<li>
										@lang('Open the Telegram app and search for the "BotFather" bot. This is the official bot provided by Telegram to create and manage bots.')

										<br>
										<br>
										<div class="code-block ">
											<img src="{{asset($themeTrue.'images/telegram/01.png')}}" class="w-50" alt="">
										</div>
										<br>
									</li>

									<li>
									@lang('Start a chat with the BotFather and follow the instructions to create a new bot. The BotFather will guide you through the process')
										<br>
										<br>
										<div class="code-block ">
											<img src="{{asset($themeTrue.'images/telegram/02.png')}}" class="w-50" alt="">
											<br><br>
											<img src="{{asset($themeTrue.'images/telegram/03.png')}}" class="w-50" alt="">

										</div>
										<br>
									</li>

									<li>
										@lang('Bot will provide you with a token/API key for your bot, Please copy the token for next step')
										<br>
										<br>
										<div class="code-block ">
											<img src="{{asset($themeTrue.'images/telegram/04.png')}}" class="w-50" alt="">
										</div>
										<br>
									</li>
								</ul>
							</div>

							<div id="Set_up_the_bot" class="padding">
								<h4 class="mt-3">@lang("Set up the bot")</h4>
								<ul>
									<li>
										@lang('Save your telegram token here')

										<br>
										<div class="code-block ">
										<img src="{{asset($themeTrue.'images/telegram/05.png')}}" class="w-50" alt="">
										</div>
									</li>
								</ul>
							</div>
							<p>
								@lang("Your Telegram bot is now set up and ready to provide its intended functionality. Remember to monitor the bot's performance, address any issues or user feedback promptly, and continue enhancing the bot's features to improve the user experience.")
							</p>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<script src="{{ asset($themeTrue . 'js/bootstrap.bundle.min.js')}}"></script>
<script src="{{ asset($themeTrue . 'js/jquery.min.js')}}"></script>
<script src="{{ asset($themeTrue . 'js/owl.carousel.min.js')}}"></script>
<script src="{{ asset($themeTrue . 'js/qrjs2.min.js')}}"></script>
<script src="{{ asset($themeTrue . 'js/socialSharing.js')}}"></script>
<script src="{{ asset('assets/global/js/notiflix-aio-3.2.6.min.js') }}"></script>
<script src="{{ asset('assets/global/js/select2.min.js') }}"></script>
<script src="{{ asset($themeTrue . 'js/script.js')}}"></script>

<script src="{{ asset('assets/global/js/pusher.min.js') }}"></script>
<script src="{{ asset('assets/global/js/vue.min.js') }}"></script>
<script src="{{ asset('assets/global/js/axios.min.js') }}"></script>

@if(session()->has('success'))
    <script>
        Notiflix.Notify.success("@lang(session('success'))");
    </script>
@endif
@if(session()->has('error'))
    <script>
        Notiflix.Notify.failure("@lang(session('error'))");
    </script>
@endif

@stack('script')

</body>
</html>
