@extends(template().'layouts.app')
@section('content')
    <section id="login" class="login-section">
        <div class="container">
            <div class="row d-flex justify-content-center">
                <div class="col-lg-6">
                    <form action="{{ route('user.twoFA-Verify') }}" method="post">
                        @csrf
                        <div class="row gy-3">
                            <div class="col-12">
                                <h4>@lang('2FA Verification')</h4>
                            </div>
                            <div class="input-box col-12">
                                <input type="text" class="form-control @error('code') is-invalid @enderror" name="code" placeholder="Verification Code">
                                @error('code')
                                <span class="invalid-feedback d-block" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                                @error('error')
                                <span class="invalid-feedback d-block" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <button type="submit" class="btn-custom w-100">@lang('Verify')</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </section>
@endsection
