@extends(template().'.layouts.app')
@section('content')
    <!-- ======= Contact Section ======= -->
    <section id="register" class="login-section">
        <div class="container">
            <div class="row d-flex justify-content-center">
                <div class="col-lg-7">
                    <form action="{{ route('register') }}" method="post">
                        @csrf
                        <div class="row g-4">
                            <div class="col-12">
                                <h4>@lang('Sign Up For New Account')</h4>
                            </div>
                            <div class="input-box col-lg-6">
                                <input type="text" name="first_name" value="{{old('first_name')}}" class="form-control" placeholder="@lang('Your First Name')">
                                @error('first_name')
                                <span class="invalid-feedback d-block" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                            </div>

                            <div class="input-box col-lg-6">
                                <input type="text" name="last_name" value="{{old('last_name')}}" class="form-control" placeholder="@lang('Your Last Name')">
                                @error('last_name')
                                <span class="invalid-feedback d-block" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                            </div>

                            <div class="input-box col-lg-12">
                                <input type="text" name="username" value="{{old('username')}}" class="form-control" placeholder="@lang('Your Username')">
                                @error('username')
                                <span class="invalid-feedback d-block" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                            </div>

                            <div class="input-box col-lg-12">
                                <input type="text" name="email" value="{{old('email')}}" class="form-control" placeholder="@lang('Your Email')">
                                @error('email')
                                <span class="invalid-feedback d-block" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                            </div>

                            <div class="input-box col-lg-12">
                                @php
                                    $country_code = (string) @getIpInfo()['code'] ?: null;
                                    $myCollection = collect(config('country'))->map(function($row) {
                                        return collect($row);
                                    });
                                    $countries = $myCollection->sortBy('code');
                                @endphp
                                <div class="input-group">
                                    <select name="phone_code" class="form-select country_code">
                                        @foreach($countries as $value)
                                            <option value="{{$value['phone_code']}}"
                                                    data-name="{{$value['name']}}"
                                                    data-code="{{$value['code']}}"
                                                {{$country_code == $value['phone_code'] ? 'selected' : ''}}>
                                                {{ __($value['phone_code']) }} <strong> ({{ __($value['name']) }})</strong>
                                            </option>
                                        @endforeach
                                    </select>
                                    <input type="text" name="phone" value="{{old('phone')}}" class="form-control"
                                           placeholder="@lang('Your Phone Number')"
                                           aria-label="Username" aria-describedby="basic-addon1">
                                </div>
                                @error('phone')
                                <span class="invalid-feedback d-block">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="input-box col-lg-12">
                                <input type="text" name="password"  value="{{old('password')}}" class="form-control" placeholder="Password">
                                @error('password')
                                <span class="invalid-feedback d-block" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                            </div>

                            <div class="input-box col-lg-12">
                                <input type="text" name="password_confirmation"  value="{{old('password_confirmation')}}" class="form-control"
                                       placeholder="Password Confirmation">
                                @error('password_confirmation')
                                <span class="invalid-feedback d-block" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                            </div>

                            @if(basicControl()->manual_recaptcha === 1 && basicControl()->manual_recaptcha_register === 1)
                                <div class="row mt-3">
                                    <div class="input-box col-8">
                                        <input type="text" tabindex="2"
                                               class="form-control form-control-lg @error('captcha') is-invalid @enderror"
                                               name="captcha" id="captcha" autocomplete="off"
                                               placeholder="Enter Captcha" required>
                                        @error('captcha')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                        @enderror
                                    </div>

                                    <div class="input-box col-4 d-flex align-items-center" data-hs-validation-validate-class>
                                        <img src="{{route('captcha').'?rand='. rand()}}" id='captcha_image'>
                                        <a class="btn" href='javascript: refreshCaptcha();'><i class="fad fa-sync"></i></a>
                                    </div>
                                </div>
                            @endif

                            @if(basicControl()->google_recaptcha && basicControl()->google_recaptcha_register)
                                <div class="col-12">
                                    <div class="g-recaptcha @error('g-recaptcha-response') is-invalid @enderror" data-sitekey="{{ env('GOOGLE_RECAPTCHA_SITE_KEY') }}"></div>
                                    @error('g-recaptcha-response')
                                    <span class="invalid-feedback d-block">{{ $message }}</span>
                                    @enderror
                                </div>
                            @endif

                            <button type="submit" class="btn-custom mt-3 w-100">@lang('Sign Up')</button>
                            <div class="bottom">
                                @lang('Already have an account?')
                                <a href="{{ route('login') }}">@lang('Login here')</a>
                            </div>
                        </div>
                    </form>
                </div>

            </div>

        </div>

    </section>
    <!-- End Contact Section -->

@endsection

@push('css-lib')
    <link rel="stylesheet" href="{{ asset($themeTrue . 'css/intlTelInput.min.css') }}">
@endpush

@push('js-lib')
    <script src="{{ asset($themeTrue . 'js/intlTelInput.min.js') }}"></script>
    <script src="https://www.google.com/recaptcha/api.js" async defer></script>
@endpush

@push('script')
    <script>

        $(document).ready(function () {

            const input = document.querySelector("#telephone");
            window.intlTelInput(input, {
                initialCountry: "bd",
                separateDialCode: true,
            });

            $('.iti__country-list li').on('click', function () {
                $("#country").val('+' + $(this).data('dial-code'));
            })

            const password = document.querySelector('.password');
            const passwordIcon = document.querySelector('.password-icon');

            passwordIcon.addEventListener("click", function () {
                if (password.type == 'password') {
                    password.type = 'text';
                    passwordIcon.classList.add('fa-eye-slash');
                } else {
                    password.type = 'password';
                    passwordIcon.classList.remove('fa-eye-slash');
                }
            })

            const confirmPassword = document.querySelector('.confirm_password');
            const confirmPasswordIcon = document.querySelector('.confirm-password-icon');

            confirmPasswordIcon.addEventListener("click", function () {
                if (confirmPassword.type == 'password') {
                    confirmPassword.type = 'text';
                    confirmPasswordIcon.classList.add('fa-eye-slash');
                } else {
                    confirmPassword.type = 'password';
                    confirmPasswordIcon.classList.remove('fa-eye-slash');
                }
            })
        });

        function refreshCaptcha() {
            let img = document.images['captcha_image'];
            img.src = img.src.substring(
                0, img.src.lastIndexOf("?")
            ) + "?rand=" + Math.random() * 1000;
        }

    </script>
@endpush
