
@extends('admin.layouts.app')
@section('page_title', __('Schedule Edit'))
@section('content')
    <div class="content container-fluid">
        <div class="page-header">
            <div class="row align-items-end">
                <div class="col-sm mb-2 mb-sm-0">
                    <nav aria-label="breadcrumb">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb breadcrumb-no-gutter">
                                <li class="breadcrumb-item"><a class="breadcrumb-link"
                                                               href="javascript:void(0);">@lang('Dashboard')</a></li>
                                <li class="breadcrumb-item" aria-current="page">@lang('Manage Plan')</li>
                                <li class="breadcrumb-item" aria-current="page">@lang('Schedules')</li>
                                <li class="breadcrumb-item active" aria-current="page">@lang('Edit')</li>
                            </ol>
                        </nav>
                        <h1 class="page-header-title">@lang('Edit From')</h1>
                </div>
            </div>
        </div>

        <div class="card">
            <div class="card-body">
                <ul class="nav nav-tabs" id="myTab" role="tablist">
                    @foreach($languages as $key => $language)
                        <li class="nav-item">
                            <a class="nav-link {{ $loop->first ? 'active' : '' }}" data-bs-toggle="tab" href="#lang-tab-{{ $key }}" role="tab" aria-controls="lang-tab-{{ $key }}"
                               aria-selected="{{ $loop->first ? 'true' : 'false' }}">@lang($language->name)</a>
                        </li>
                    @endforeach
                </ul>

                <div class="tab-content mt-2" id="myTabContent">
                    @foreach($languages as $key => $language)
                        <div class="tab-pane fade {{ $loop->first ? 'show active' : '' }}" id="lang-tab-{{ $key }}" role="tabpanel">
                            <form method="post" action="{{ route('admin.schedule.update', [$id, $language->id]) }}" class="mt-4" enctype="multipart/form-data">
                                @csrf
                                @method('put')
                                <div class="row mb-2 d-flex">
                                    <div class="{{ $loop->index == 0 ? 'col-lg-4' : 'col-lg-12' }}">
                                        <label for="nameLabel" class="form-label">@lang('Schedule Name')</label>
                                        <input type="text" class="form-control @error('name'.'.'.$language->id) is-invalid @enderror"
                                               name="name[{{ $language->id }}]" id="nameLabel" placeholder="@lang('Enter Name')" aria-label="Name"
                                               autocomplete="off"
                                               value="{{ old('name'.'.'.$language->id, isset($scheduleDetails[$language->id]) ? $scheduleDetails[$language->id][0]->name : '') }}">
                                        @error('name'.'.'.$language->id)
                                        <span class="invalid-feedback">{{ $message }}</span>
                                        @enderror
                                    </div>

                                    @if ($loop->index == 0)
                                        <div class="col-lg-4">
                                            <label for="priceLabel" class="form-label">@lang('Duration')</label>
                                            <div class="input-group">
                                                <input type="number" class="form-control @error('days') is-invalid @enderror"
                                                       name="days" value="{{ old('days'.$language->id, isset($scheduleDetails[$language->id]) ? $scheduleDetails[$language->id][0]->schedule->days : '') }}"
                                                       placeholder="@lang('Enter days')"
                                                       aria-label="Plan Price" aria-describedby="basic-addon2">
                                                <span class="input-group-text" id="basic-addon2">@lang('Days')</span>
                                                @error('days')
                                                <span class="invalid-feedback">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>

                                        <div class="form-group col-lg-4">
                                            <label class="form-label">@lang('Status')</label>
                                            <div class="list-group-item">
                                                <div class="d-flex">
                                                    <div class="flex-grow-1">
                                                        <div class="row align-items-center">
                                                            <div class="col">
                                                                <span class="d-block fs-6 text-body">
                                                                    @lang('You can either switch to active mode or inactive mode, depending on your preference or the situation')
                                                                </span>
                                                            </div>
                                                            <div class="col-auto">
                                                                <label class="row form-check form-switch mb-3" for="is_video">
                                                                    <span class="col-4 col-sm-3 text-end">
                                                                        <input type='hidden' value='0' name='status'>
                                                                        <input class="form-check-input @error('status') is-invalid @enderror"
                                                                               type="checkbox" name="status" id="status" value="1"
                                                                        {{ isset($scheduleDetails[$language->id]) ? ($scheduleDetails[$language->id][0]->schedule->status  == "1" ? 'checked' : '') : '' }}>
                                                                    </span>
                                                                    @error('status')
                                                                    <span class="invalid-feedback d-block">{{ $message }}</span>
                                                                    @enderror
                                                                </label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @endif
                                </div>
                                <button type="submit" class="btn waves-effect waves-light btn-rounded btn-primary btn-block mt-3 w-100">@lang('Save changes')</button>
                            </form>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
@endsection



