@extends('admin.layouts.app')
@section('page_title',__('Order Details'))
@section('content')
    <div class="content container-fluid">
        <div class="page-header">
            <div class="row align-items-end">
                <div class="col-sm mb-2 mb-sm-0">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb breadcrumb-no-gutter">
                            <li class="breadcrumb-item"><a class="breadcrumb-link"
                                                           href="javascript:void(0);">@lang('Dashboard')</a></li>
                            <li class="breadcrumb-item" aria-current="page">@lang('Manage Module')</li>
                            <li class="breadcrumb-item" aria-current="page">@lang('Order Items')</li>
                            <li class="breadcrumb-item active" aria-current="page">@lang('Details')</li>
                        </ol>
                    </nav>
                    <h1 class="page-header-title">@lang(optional($order->store)->name .' - Order Number#'.$order->order_number)</h1>
                </div>
            </div>
        </div>

        <div class="row g-4">
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-header card-header-content-md-between">
                        <h4>@lang(optional($order->store)->name .' - Order Number#'.$order->order_number)</h4>
                    </div>

                    <div class="card-body">
                        <div class=" table-responsive datatable-custom  ">
                            <table class="table table-striped table-hover table-thead-bordered  table-align-middle card-table">
                                <thead class="thead-light">
                                <tr>
                                    <th>@lang('SL.')</th>
                                    <th>@lang('Item Name')</th>
                                    <th>@lang('Add Ons')</th>
                                    <th>@lang('Price')</th>
                                    <th>@lang('Quantity')</th>
                                    <th>@lang('Total Price')</th>
                                </tr>
                                </thead>
                                <tbody>
                                @foreach($order->details as $key => $item)
                                    <tr>
                                        <td data-label="@lang('SL.')">{{++$key}}</td>
                                        <td data-label="@lang('Item Name')">
                                            <a class="d-flex align-items-center me-2" href="{{route('admin.menu.details',$item->product_id)}}">
                                                <div class="flex-shrink-0">
                                                    <div class="avatar avatar-sm avatar-circle">
                                                        <img class="avatar-img" src="{{getFile(optional($item->product)->driver,optional($item->product)->image)}}" alt="Image">
                                                    </div>
                                                </div>
                                                <div class="flex-grow-1 ms-3">
                                                    <h5 class="text-hover-primary mb-0">{{($item->variant_name)??$item->product_name}}</h5>
                                                    <span class="fs-6 text-body">{{ optional($item->product)->sku }}</span>
                                                </div>
                                            </a>
                                        </td>
                                        <td data-label="@lang('Add Ons')">
                                            @if(count($item->extra_products())>0)
                                                @foreach($item->extra_products() as $addon)
                                                    <a href="javascript:void(0)"><span
                                                            class="badge bg-soft-secondary text-secondary mb-1">{{ $addon->name }}({{ currencyPosition(getAmount($addon->price)) }})</span></a>
                                                @endforeach
                                            @else
                                                -
                                            @endif
                                        </td>
                                        <td data-label="@lang('Price')">{{ currencyPosition(getAmount($item->price)) }}</td>
                                        <td data-label="@lang('Quantity')">{{ $item->quantity }}</td>
                                        <td data-label="@lang('Total Price')"><span
                                                class="text-secondary">{{ currencyPosition(getAmount($item->total_price)) }}</span>
                                        </td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="card">
                    <div class="card-header card-header-content-md-between">
                        <h4>@lang('Buyer Details')</h4>
                        @if($order->stage == 0)
                            <span class="badge bg-soft-warning text-warning">@lang('New Arrive')</span>
                        @elseif($order->stage == 1)
                            <span class="badge bg-soft-success text-success">@lang('Delivered')</span>
                        @elseif($order->stage == 2)
                            <span class="badge bg-soft-info text-info">@lang('In Process')</span>
                        @elseif($order->stage == 3)
                            <span class="badge bg-soft-primary text-primary">@lang('Out For Delivery')</span>
                        @elseif($order->stage == 4)
                            <span class="badge bg-soft-danger text-danger">@lang('Canceled')</span>
                        @endif
                    </div>

                    <div class="card-body">
                        <ul class="list-group">
                            <li class="list-group-item d-flex justify-content-between">
                                <span class="text-secondary">@lang('Order Date')</span>
                                <span class="text-secondary">{{dateTime($order->created_at,'d/M/Y H:i')??'N/A'}}</span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between">
                                <span class="text-secondary">@lang('Payment Type')</span>
                                <span class="text-secondary">{{ $order->gateway_id == 0 ? 'Cash On Delivery' : 'Automatic' }}</span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between">
                                <span class="text-secondary">@lang('Payment Status')</span>
                                <span class="badge bg-soft-{{ $order->gateway_id == 0 && $order->stage != 1 ? 'danger text-danger' : 'success text-success' }}">{{ $order->gateway_id == 0 && $order->stage != 1 ? 'Unpaid' : 'Paid' }}</span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between">
                                <span class="text-secondary">@lang('Full Name')</span>
                                <span class="text-secondary">@lang($order->full_name ?? 'N/A')</span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between">
                                <span class="text-secondary">@lang('Email')</span>
                                <span class="text-secondary">@lang($order->email ?? 'N/A')</span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between">
                                <span class="text-secondary">@lang('Phone')</span>
                                <span class="text-secondary">@lang($order->phone ?? 'N/A')</span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between">
                                <span class="text-secondary">@lang('Alt. Phone')</span>
                                <span class="text-secondary">@lang($order->alt_phone ?? 'N/A')</span>
                            </li>
                            @if($order->shipping_id)
                                <li class="list-group-item d-flex justify-content-between">
                                    <span class="text-secondary">@lang('Shipping Address')</span>
                                    <span class="text-secondary">@lang(optional($order->shipping)->address ?? 'N/A')</span>
                                </li>
                            @endif
                            <li class="list-group-item d-flex justify-content-between">
                                <span class="text-secondary">@lang('Details Address')</span>
                                <span class="text-secondary">@lang($order->detailed_address ?? 'N/A')</span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between">
                                <span class="text-secondary">@lang('Total Amount')</span>
                                <span class="text-secondary">{{ currencyPosition(getAmount($order->total_amount)) }}</span>
                            </li>
                            @if($order->shipping_charge > 0)
                                <li class="list-group-item d-flex justify-content-between">
                                    <span class="text-secondary">@lang('Shipping Charge')</span>
                                    <span class="text-secondary">{{ currencyPosition(getAmount($order->shipping_charge)) }}</span>
                                </li>
                            @endif
                            <li class="list-group-item d-flex justify-content-between">
                                <span class="text-secondary">@lang('Discount')</span>
                                <span class="text-secondary">{{ currencyPosition(getAmount($order->discount_amount)) }}</span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between">
                                <span class="text-secondary">@lang('Payment Amount')</span>
                                <span class="text-secondary">{{ currencyPosition(getAmount($order->payment_amount)) }}</span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between">
                                <span class="text-secondary me-3">@lang('Delivery Note')</span>
                                <span class="text-secondary">@lang($order->delivery_note)</span>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection





