@extends('admin.layouts.app')
@section('page_title',__('Menu'))
@section('content')
    <div class="content container-fluid">
        <div class="page-header">
            <div class="row align-items-end">
                <div class="col-sm mb-2 mb-sm-0">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb breadcrumb-no-gutter">
                            <li class="breadcrumb-item"><a class="breadcrumb-link"
                                                           href="javascript:void(0);">@lang('Dashboard')</a></li>
                            <li class="breadcrumb-item" aria-current="page">@lang('Manage Module')</li>
                            <li class="breadcrumb-item" aria-current="page">@lang('Menu Item')</li>
                            <li class="breadcrumb-item active" aria-current="page">@lang('Details')</li>
                        </ol>
                    </nav>
                    <h1 class="page-header-title">@lang('Menu - '.$product->name)</h1>
                </div>
            </div>
        </div>

        <div class="row g-4">
            <div class="col-lg-6">
                <div class="card">
                    <div class="card-header card-header-content-md-between">
                        <h4>@lang($product->name)</h4>
                    </div>

                    <div class="card-body">
                        <ul class="list-group">
                            <li class="list-group-item d-flex justify-content-between">
                                <span>{{ __('Menu Name') }}</span>
                                <span class="text-secondary">{{$product->name}}</span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between">
                                <span>{{ __('Category') }}</span>
                                <span class="text-secondary">{{optional($product->category)->name}}</span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between">
                                <span>{{ __('Price') }}</span>
                                <span class="text-secondary">{{ currencyPosition(getAmount($product->price)) }}</span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between">
                                <span>{{ __('Sku') }}</span>
                                <span class="text-secondary">{{$product->sku}}</span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between">
                                <span>{{ __('Tag') }}</span>
                                <span class="text-secondary">{{$product->tag}}</span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between">
                                <span>{{ __('Image') }}</span>
                                <span class="text-decoration-none">
                                    <div class="d-lg-flex d-block align-items-center ">
                                        <div class=""><img
                                                src="{{ getFile($product->driver,$product->image) }}"
                                                alt="user" class="rounded-circle"
                                                width="40" data-toggle="tooltip"
                                                title=""
                                                data-original-title="{{$product->name}}">
                                        </div>
                                    </div>
                                </span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between">
                                <span class="me-3">{{ __('Description') }}</span>
                                <p class="text-justify text-secondary">{{$product->description}}</p>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="card">
                    <div class="card-header card-header-content-md-between">
                        <h4>@lang($product->name)</h4>
                        @if($product->status == 1)
                            <span class="badge bg-success">@lang('Active')</span>
                        @else
                            <span class="badge bg-danger">@lang('Inactive')</span>
                        @endif
                    </div>

                    <div class="card-body">
                        <ul class="list-group">
                            @if(count($product->productStores)>0)
                                <li class="list-group-item d-flex justify-content-between">
                                    <span class="mr-3">{{ __('Stores') }}</span>
                                    <div class="d-flex justify-content-between">
                                        @foreach($product->productStores->unique('store_id') as $store)
                                            <span
                                                class="badge bg-soft-secondary text-secondary me-1">{{optional($store->store)->name}}</span>
                                        @endforeach
                                    </div>
                                </li>
                            @endif
                            @if(count($product->extra_products()) > 0)
                                <li class="list-group-item d-flex justify-content-between">
                                    <span class="mr-3">{{ __('Add Ons') }}</span>
                                    <div class="d-flex justify-content-between">
                                        @foreach($product->extra_products() as $addOn)
                                            <span
                                                class="badge bg-soft-secondary text-secondary me-1">{{$addOn->name}}-({{ currencyPosition($addOn->price) }})</span>
                                        @endforeach
                                    </div>
                                </li>
                            @endif
                            @if($product->variants)
                                <li class="list-group-item d-flex justify-content-between">
                                    <span class="mr-3">{{ __('Variants') }}</span>
                                    <div class="d-flex justify-content-between">
                                        @foreach($product->variants as $variant)
                                            <span
                                                class="badge bg-soft-secondary text-secondary me-1">{{$variant->variant_name}}-({{ currencyPosition($variant->variant_price) }})</span>
                                        @endforeach
                                    </div>
                                </li>
                            @endif
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection





