<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('order_details', function (Blueprint $table) {
            $table->id();
            $table->foreignId('order_id')->index()->nullable();
            $table->foreignId('product_id')->index()->nullable();
            $table->string('product_name')->nullable();
            $table->integer('quantity')->nullable();
            $table->double('price')->default(0);
            $table->double('total_price')->default(0);
            $table->string('variant_name')->nullable();
            $table->double('variant_price')->default(0);
            $table->text('extra_products')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('order_details');
    }
};
