<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('opening_schedules', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->index()->nullable();
            $table->foreignId('store_id')->index()->nullable();
            $table->string('day')->nullable();
            $table->time('from')->nullable();
            $table->time('to')->nullable();
            $table->tinyInteger('off_day')->default(0)->comment('0 : No, 1 : Yes');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('opening_schedules');
    }
};
