<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('plans', function (Blueprint $table) {
            $table->id();
            $table->integer('num_stores')->default(0);
            $table->integer('product_qty')->default(0);
            $table->integer('order_num')->default(0);
            $table->boolean('telegram_bot')->default(0)->comment('0: No,1: Yes');
            $table->boolean('messenger_bot')->default(0)->comment('0: No,1: Yes');
            $table->boolean('whatsapp_bot')->default(0)->comment('0: No,1: Yes');
            $table->boolean('status')->default(0)->comment('0=ff,1=on');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('plans');
    }
};
