<?php

namespace App\Services\Bot;

class telegram
{
	public function getBot($token)
	{
		$curl = curl_init();

		curl_setopt_array($curl, array(
			CURLOPT_URL => 'https://api.telegram.org/bot' . $token . '/getMe',
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => 'GET',
		));

		$response = curl_exec($curl);
		curl_close($curl);
		$res = json_decode($response);

		if (isset($res) && $res->ok) {
			return [
				'status' => 'success',
				'res' => $res,
			];
		} else {
			return [
				'status' => 'error',
			];
		}
	}

	public function webhookSet($token, $link)
	{
		$curl = curl_init();

		curl_setopt_array($curl, array(
			CURLOPT_URL => 'https://api.telegram.org/bot' . $token . '/setWebhook?url=' . route('telegramWebhook', $link),
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => 'GET',
		));

		$response = curl_exec($curl);
		curl_close($curl);

		$res = json_decode($response);

		if (isset($res) && $res->ok) {
			return [
				'status' => 'success',
				'res' => $res,
			];
		} else {
			return [
				'status' => 'error',
			];
		}
	}
}
