<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Cache;

class StoreProduct extends Model
{
    protected $table = 'store_products';
    protected $guarded =['id'];
    protected $casts = [
        'extra_products' => 'array',
        'variants' => 'object'
    ];

    public function scopeOwn($query, $userId)
    {
        return $query->where('user_id', $userId);
    }

    public function category()
    {
        return $this->belongsTo(StoreCategory::class, 'category_id');
    }

    public function productStores()
    {
        return $this->hasMany(ProductStoreMap::class, 'product_id');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function extra_products()
    {
        return StoreProductOptional::whereIn('id', $this->extra_products)->get();
    }

    public function orderDetails()
    {
        return $this->hasMany(OrderDetail::class, 'product_id');
    }

    public static function boot(): void
    {
        parent::boot();
        static::saved(function () {
            Cache::forget('storeProductRecord');
        });
    }
}
