<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PlanSchedule extends Model
{
    use HasFactory;

    protected $table = 'plan_schedules';
    protected $guarded = ['id'];

    public function planDetail()
    {
        return $this->belongsTo(Plan::class, 'plan_id');
    }
    public function scheduleDetail()
    {
        return $this->belongsTo(Schedule::class, 'schedule_id');
    }

    public function transactional()
    {
        return $this->morphOne(Transaction::class, 'transactional');
    }
}
