<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class NotificationPermission extends Model
{
    use HasFactory;

    protected $table = 'notification_permissions';
    protected $guarded = ['id'];

    public function notifyable(){
        return $this->morphTo(__FUNCTION__, 'notifyable_type', 'notifyable_id');
    }

    protected $casts = [
        'template_email_key' => 'array',
        'template_sms_key' => 'array',
        'template_in_app_key' => 'array',
        'template_push_key' => 'array'
    ];
}
