<?php

namespace App\Http\Controllers;

use App\Models\Order;
use App\Models\Store;
use App\Traits\Notify;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;

class TelegramNotificationController extends Controller
{

	public function reply(Request $request, $link)
	{
		$store = Store::where('status', 1)->where('link', $link)->first();
		$senderId = $request->message['chat']['id'];
		$command = str_replace(['<', '>'], ['&#60;', '&#62;'], $request->message['text']);

		if ($command == '/menu' || $command == '/start') {

			$telegramObj = 'App\\Services\\TelegramServices';
			$data = $telegramObj::getMenu($store, $senderId);
			return $data;

		} elseif ($command == '/lastorder') {

			$telegramObj = 'App\\Services\\TelegramServices';
			$data = $telegramObj::getLastOrder($store, $senderId);
			return $data;

		} elseif ($command == '/totalorders') {

			$telegramObj = 'App\\Services\\TelegramServices';
			$data = $telegramObj::getTotalOrders($store, $senderId);
			return $data;

		} elseif ($command == '/lastorderstatus') {

			$telegramObj = 'App\\Services\\TelegramServices';
			$data = $telegramObj::getLastOrderStatus($store, $senderId);
			return $data;

		} elseif ($command == '/totalorderamount') {

			$telegramObj = 'App\\Services\\TelegramServices';
			$data = $telegramObj::getTotalorderAmount($store, $senderId);
			return $data;

		} elseif ($command == '/last10transaction') {

			$telegramObj = 'App\\Services\\TelegramServices';
			$data = $telegramObj::getLast10Transaction($store, $senderId);
			return $data;

		} elseif ($command == '/help') {

			$telegramObj = 'App\\Services\\TelegramServices';
			$data = $telegramObj::getHelp($store, $senderId);
			return $data;

		} else {

			$telegramObj = 'App\\Services\\TelegramServices';
			$data = $telegramObj::unrecognized($store, $senderId);
			return $data;

		}

	}

}
