<?php

namespace App\Http\Controllers;

use App\Models\Store;
use Illuminate\Http\Request;

class FacebookNotificationController extends Controller
{
	public function reply(Request $request, $link)
	{
		if ($request->method() == 'GET') {
			if (isset($_REQUEST['hub_mode']) && $_REQUEST['hub_mode'] == 'subscribe') {
				$challenge = $_REQUEST['hub_challenge'];
				header("HTTP / 1.1 200 OK");
				echo $challenge;
				die;
			}
		} else {
			$store = Store::where('status', 1)->where('link', $link)->first();
			$senderId = $request->entry[0]['messaging'][0]['sender']['id'] ?? null;
			$command = $request->entry[0]['messaging'][0]['message']['text'] ?? null;
            
			if (!empty($senderId) && !empty($command) && strtolower($command) == '/menu') {

				$telegramObj = 'App\\Services\\FacebookServices';
				$data = $telegramObj::getMenu($store, $senderId);
				return $data;

			}elseif (!empty($senderId) && !empty($command) && strtolower($command) == '/lastorder') {

				$telegramObj = 'App\\Services\\FacebookServices';
				$data = $telegramObj::getLastOrder($store, $senderId);
				return $data;

			}elseif (!empty($senderId) && !empty($command) && strtolower($command) == '/totalorders') {

				$telegramObj = 'App\\Services\\FacebookServices';
				$data = $telegramObj::getTotalOrders($store, $senderId);
				return $data;

			} elseif (!empty($senderId) && !empty($command) && strtolower($command) == '/lastorderstatus') {

				$telegramObj = 'App\\Services\\FacebookServices';
				$data = $telegramObj::getLastOrderStatus($store, $senderId);
				return $data;

			}elseif (!empty($senderId) && !empty($command) && strtolower($command) == '/totalorderamount') {

				$telegramObj = 'App\\Services\\FacebookServices';
				$data = $telegramObj::getTotalorderAmount($store, $senderId);
				return $data;
			}elseif (!empty($senderId) && !empty($command) && strtolower($command) == '/last10transaction') {

				$telegramObj = 'App\\Services\\FacebookServices';
				$data = $telegramObj::getLast10Transaction($store, $senderId);
				return $data;
			}elseif (!empty($senderId) && !empty($command) && strtolower($command) == '/help') {
				$telegramObj = 'App\\Services\\FacebookServices';
				$data = $telegramObj::getHelp($store, $senderId);
				return $data;

			}
		}
	}
}
