
<?php if(!empty($blog)): ?>
	<section class="blog-section <?php echo e(getLastSegment() == 'Blogs' ? 'blog-page' : ''); ?>">
		<div class="container">
			<?php if(!empty($blog['single']) && getLastSegment() != 'Blogs'): ?>
				<div class="row">
					<div class="col-12">
						<div class="header-text text-center">
							<h5><?php echo app('translator')->get($blog['single']['heading'] ?? ''); ?></h5>
							<h2><?php echo app('translator')->get($blog['single']['title'] ?? ''); ?></h2>
						</div>
					</div>
				</div>
			<?php endif; ?>
			<div class="row g-4">
                <?php $__currentLoopData = $blog['blogs']->take(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                    <div class="col-lg-4">
                        <div class="blog-box">
                            <div class="img-box">
                                <img src="<?php echo e(getFile($item->blog_image_driver,$item->blog_image)); ?>" class="img-fluid" alt="image">
                            </div>
                            <div class="text-box">
                                <a href="<?php echo e(route('blog.details', optional($item->details)->slug)); ?>" class="title"><?php echo app('translator')->get(optional($item->details)->title); ?></a>
                                <div class="date-author">
                                    <span><?php echo app('translator')->get(dateTime($item->created_at,'d M, Y')); ?></span>
                                </div>
                                <p><?php echo app('translator')->get(strip_tags(Str::limit(optional($item->details)->description,170))); ?></p>
                                <a href="<?php echo e(route('blog.details', optional($item->details)->slug)); ?>" class="read-more"><?php echo app('translator')->get('read more'); ?></a>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
			</div>
            <?php if(getLastSegment() == 'Blogs'): ?>
                <div class="row">
                    <div class="col">
                        <nav aria-label="Page navigation example">
                            <ul class="pagination justify-content-center">
                                <?php echo e($blog['blogs']->appends($_GET)->links(template().'partials.pagination')); ?>

                            </ul>
                        </nav>
                    </div>
                </div>
            <?php endif; ?>
		</div>
	</section>
<?php endif; ?>


<?php /**PATH D:\server\htdocs\FoodyFriend-v3\DEMO\resources\views/themes/light/sections/blog.blade.php ENDPATH**/ ?>