
<section class="plan-section <?php echo e(getLastSegment() == 'Pricing' ? 'plan-page' : ''); ?>">
	<div class="container">
		<?php if(!empty($plan['single']) && getLastSegment() != 'Pricing'): ?>
			<div class="row">
				<div class="col-12">
					<div class="header-text text-center">
						<h5><?php echo app('translator')->get($plan['single']['heading'] ?? ''); ?></h5>
						<h2><?php echo app('translator')->get($plan['single']['title'] ?? ''); ?></h2>
						<p class="mx-auto"><?php echo app('translator')->get($plan['single']['sub_title'] ?? ''); ?></p>
					</div>
				</div>
			</div>
		<?php endif; ?>

		<?php if(!empty($plan['schedules'])): ?>
			<div class="text-center">
				<div class="nav nav-pills" id="pills-tab" role="tablist">
					<?php $__currentLoopData = $plan['schedules']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $schedule): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<button
							class="btn-custom <?php echo e(($key == 0)?'active':''); ?>"
							id="pills-<?php echo e($key); ?>-tab"
							data-bs-toggle="pill"
							data-bs-target="#pills-<?php echo e($key); ?>"
							type="button"
							role="tab"
							aria-controls="pills-<?php echo e($key); ?>"
							aria-selected="true">
							<?php echo e(optional($schedule->details)->name); ?>

						</button>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				</div>
			</div>

			<div class="tab-content" id="pills-tabContent">
				<?php $__currentLoopData = $plan['schedules']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $schedule): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					<div class="tab-pane fade <?php echo e(($key == 0)?'show active':''); ?>"
						id="pills-<?php echo e($key); ?>"
						role="tabpanel"
						aria-labelledby="pills-<?php echo e($key); ?>-tab">
						<div class="row g-4 g-lg-5">
							<?php if($schedule->plans): ?>
								<?php $__currentLoopData = $schedule->plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<?php if(optional($plan->planDetail)->status == 0): ?>
										<?php
											continue;
										?>
									<?php endif; ?>
									<div class="col-lg-4 col-md-6">
										<div class="plan-box"
											data-aos="fade-up"
											data-aos-duration="1000"
											data-aos-anchor-placement="center-bottom">
											<div class="top-area">
												<h4><?php echo e(optional(optional($plan->planDetail)->details)->plan_name); ?></h4>
												<h1><?php echo e(currencyPosition($plan->price)); ?>

													<span>/<?php echo e(ucfirst(optional($schedule->details)->name)); ?></span></h1>
												<p><?php echo e(optional(optional($plan->planDetail)->details)->note); ?></p>
											</div>
											<ul>
												<li>
													<i class="fal fa-check-circle fa-2x text-success"></i><?php echo e(optional($plan->planDetail)->num_stores); ?> <?php echo app('translator')->get('Number of stores'); ?>
												</li>
												<li>
													<i class="fal fa-check-circle fa-2x text-success"></i><?php echo e(optional($plan->planDetail)->product_qty); ?> <?php echo app('translator')->get('Menu Items Business'); ?>
												</li>
												<li>
													<i class="fal fa-check-circle fa-2x text-success"></i> <?php echo e(optional($plan->planDetail)->order_num); ?> <?php echo app('translator')->get('Orders completed'); ?>
												</li>

												<li>
                                                    <i class="<?php echo e(optional($plan->planDetail)->telegram_bot == 1 ? 'fal fa-check-circle fa-2x text-success' : 'fal fa-times-circle fa-2x text-danger'); ?>"></i>
                                                    <?php echo app('translator')->get('Telegram Bot'); ?>
												</li>

												<li>
                                                    <i class="<?php echo e(optional($plan->planDetail)->messenger_bot == 1 ? 'fal fa-check-circle fa-2x text-success' : 'fal fa-times-circle fa-2x text-danger'); ?>"></i>
													<?php echo app('translator')->get('Messenger Bot'); ?>
												</li>

												<li>
                                                    <i class="<?php echo e(optional($plan->planDetail)->whatsapp_bot == 1 ? 'fal fa-check-circle fa-2x text-success' : 'fal fa-times-circle fa-2x text-danger'); ?>"></i>
													<?php echo app('translator')->get('Whatsapp Bot'); ?>
												</li>
											</ul>
											<a href="<?php echo e(route('user.purchase.plan',$plan->id)); ?>"
											   class="btn-custom w-100"><?php echo app('translator')->get('Get started'); ?></a>
											<span class="feature"><?php echo e(ucfirst(optional(optional($plan->planDetail)->details)->plan_name)); ?></span>
										</div>
									</div>
								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
							<?php endif; ?>
						</div>
					</div>
				<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
			</div>
		<?php endif; ?>
	</div>
</section>
<?php /**PATH D:\server\htdocs\FoodyFriend-v3\DEMO\resources\views/themes/light/sections/plan.blade.php ENDPATH**/ ?>