<!-- Modal section start -->

<?php
    $pwa_popup = getSectionData('pwa_popup');
?>

<div class="pwa-popup" id="pwaInstallPopup">
    <div class="header">

        <div class="d-flex flex-wrap">
            <img src="<?php echo e(isset($pwa_popup['single']['content']['media']->image)?getFile($pwa_popup['single']['content']['media']->image->driver,$pwa_popup['single']['content']['media']->image->path):""); ?>" alt="PWA Logo"
                 class="pwa-logo">
            <div class="header-text ms-3 mb-1">
                <h2><?php echo e($pwa_popup['single']['description']->title ?? ''); ?></h2>
                <p><?php echo e($_SERVER['HTTP_HOST']); ?></p>
            </div>
        </div>
        <button class="close-btn carousel_close_btn">×</button>
    </div>
    <p class="description">
        <?php echo e($pwa_popup['single']['description']->short_description ?? ''); ?>

    </p>
    <p class="sub-description">
        <?php echo e($pwa_popup['single']['description']->description ?? ''); ?>

    </p>
    <div class="carousel-container" id="carouselContainer">
        <div class="carousel">
            <button class="carousel-btn left" id="prevBtn">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                    <path fill="currentColor" d="M15.41 7.41L14 6l-6 6 6 6 1.41-1.41L10.83 12z"/>
                </svg>
            </button>
            <div class="carousel-content" id="carouselContent">
                <?php $__currentLoopData = collect($pwa_popup['multiple'])->toArray(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <img src="<?php echo e(isset($item['content']['media']->image)?getFile($item['content']['media']->image->driver,$item['content']['media']->image->path):''); ?>" alt="Carousel Image">
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </div>
            <button class="carousel-btn right" id="nextBtn">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                    <path fill="currentColor" d="M8.59 16.59L10 18l6-6-6-6-1.41 1.41L13.17 12z"/>
                </svg>
            </button>
        </div>
    </div>
    <div class="actions">
        <button class="btn-custom2 less" id="toggleCarousel"><?php echo app('translator')->get('More'); ?></button>
        <button class="btn-custom install" id="installButton"><?php echo app('translator')->get('Install'); ?></button>
    </div>
</div>


<script>

    const popup = document.getElementById('pwaInstallPopup');
    const showButton = document.getElementById('toggleCarousel'); // Example button to show
    const closeButton = document.querySelector('.close-btn');

    document.querySelector('.carousel_close_btn').addEventListener('click',()=>{
        var $modal = $("#pwaInstallPopup");
        $modal.hide();

        localStorage.setItem('pwa_install','not_install');
    })



    const carouselContainer = document.getElementById('carouselContainer');
    const toggleCarouselBtn = document.getElementById('toggleCarousel');
    const carouselContent = document.getElementById('carouselContent');
    const prevBtn = document.getElementById('prevBtn');
    const nextBtn = document.getElementById('nextBtn');

    let currentIndex = 0;

    // Toggle visibility of the carousel with dynamic height
    toggleCarouselBtn.addEventListener('click', () => {
        if (carouselContainer.classList.contains('active')) {
            // Collapse the carousel
            carouselContainer.style.height = '0';
            carouselContainer.classList.remove('active');
            toggleCarouselBtn.textContent = 'More';
        } else {
            // Expand the carousel to 80% of the viewport height
            const carouselHeight = window.innerHeight * 0.5;
            carouselContainer.style.height = `${carouselHeight}px`;
            carouselContainer.classList.add('active');
            toggleCarouselBtn.textContent = 'Less';
        }
    });

    // Carousel navigation logic
    prevBtn.addEventListener('click', () => {
        if (currentIndex > 0) {
            currentIndex--;
            updateCarousel();
        }
    });

    nextBtn.addEventListener('click', () => {
        if (currentIndex < carouselContent.children.length - 1) {
            currentIndex++;
            updateCarousel();
        }
    });

    function updateCarousel() {
        const offset = -currentIndex * 100; // Move carousel by 100% per slide
        carouselContent.style.transform = `translateX(${offset}%)`;
    }




    window.addEventListener('load', () => {
        const isFirefox = navigator.userAgent.includes('Firefox');
        let deferredPrompt = null;

        if (!isFirefox && 'BeforeInstallPromptEvent' in window) {
            window.addEventListener('beforeinstallprompt', (e) => {

                e.preventDefault();
                deferredPrompt = e;

                const installButton = document.getElementById('installButton');
                let pwaStatus = localStorage.getItem('pwa_install');
                if (pwaStatus !== 'not_install' && pwaStatus !== 'install') {
                    $("#pwaInstallPopup").show(); // Show your modal
                }

                installButton.addEventListener('click', async () => {
                    deferredPrompt.prompt();
                    const { outcome } = await deferredPrompt.userChoice;
                    deferredPrompt = null;
                    if (outcome === 'accepted') {
                        localStorage.setItem('pwa_install', 'install');
                    } else {
                        localStorage.setItem('pwa_install', 'not_install');
                    }
                });
            });
        } else if (isFirefox) {
            const installButton = document.getElementById('installButton');
            let pwaStatus = localStorage.getItem('pwa_install');
            if (pwaStatus !== 'not_install' && pwaStatus !== 'install') {
                $("#pwaInstallPopup").show(); // Show your modal with Firefox-specific instructions
            }

            installButton.addEventListener('click', () => {
                // Show custom instructions for Firefox
                alert("To install the app on Firefox, use a mobile device. Open the browser menu (three dots in the top-right corner) and select 'Add to Home Screen'.");
                localStorage.setItem('pwa_install', 'install');
            });
        }
    });
</script>
<?php /**PATH D:\server\htdocs\FoodyFriend-v3\DEMO\resources\views/themes/light/partials/pwa.blade.php ENDPATH**/ ?>