<?php

use App\Http\Controllers\Auth\LoginController as UserLoginController;
use App\Http\Controllers\CommonController;
use App\Http\Controllers\FrontendController;
use App\Http\Controllers\PaymentController;
use App\Http\Controllers\SocialiteController;
use App\Http\Controllers\User\HomeController;
use App\Http\Controllers\User\DepositController;
use App\Http\Controllers\User\NotificationPermissionController;
use App\Http\Controllers\User\OrderController;
use App\Http\Controllers\User\PaymentGatewayController;
use App\Http\Controllers\ManualRecaptchaController;
use App\Http\Controllers\khaltiPaymentController;
use App\Http\Controllers\User\PurchasePlanController;
use App\Http\Controllers\User\StoreCategoryController;
use App\Http\Controllers\User\StoreController;
use App\Http\Controllers\User\StoreCouponController;
use App\Http\Controllers\User\StoreProductController;
use App\Http\Controllers\User\StoreProductOptionalController;
use App\Http\Controllers\User\StoreShippingController;
use App\Http\Controllers\User\TransactionController;
use App\Models\Store;
use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\InAppNotificationController;
use App\Http\Controllers\User\SupportTicketController;
use App\Http\Controllers\Auth\ForgotPasswordController;
use App\Http\Controllers\Auth\ResetPasswordController;
use App\Http\Controllers\User\VerificationController;
use App\Http\Controllers\Frontend\BlogController;
use App\Http\Controllers\User\KycVerificationController;
use App\Http\Controllers\TwoFaSecurityController;
use App\Http\Controllers\StoreShopController;
use App\Http\Controllers\CheckoutController;
use Illuminate\Support\Facades\File;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/


$basicControl = basicControl();
Route::get('language/{locale}', function ($locale) {
    app()->setLocale($locale);
    session()->put('lang', $locale);
    return redirect()->back();
})->name('language');

Route::get('maintenance-mode', function () {
    if (!basicControl()->is_maintenance_mode) {
        return redirect(route('page'));
    }
    $data['maintenanceMode'] = \App\Models\MaintenanceMode::first();
    return view(template() . 'maintenance', $data);
})->name('maintenance');

Route::get('password/reset', [ForgotPasswordController::class, 'showLinkRequestForm'])->name('password.request');
Route::post('forget-password-link', [ForgotPasswordController::class, 'submitForgetPassword'])->name('password.reset.email');
Route::get('password/reset/{token}', [ResetPasswordController::class, 'showResetForm'])->name('password.reset')->middleware('guest');
Route::post('password/reset/update', [ResetPasswordController::class, 'resetPassword'])->name('password.reset.update');

Route::match(['get', 'post'], 'payment/{code}/{trx?}/{type?}', [PaymentController::class, 'gatewayIpn'])->name('ipn');

Route::get('instruction/page', function () {
    return view('instruction-page');
})->name('instructionPage');

Route::group(['middleware' => ['maintenanceMode']], function () use ($basicControl) {
    Route::group(['middleware' => ['guest']], function () {
        Route::get('/login', [UserLoginController::class, 'showLoginForm'])->name('login');
        Route::post('/login', [UserLoginController::class, 'login'])->name('login.submit');
    });

    Route::group(['middleware' => ['auth'], 'prefix' => 'user', 'as' => 'user.'], function () {

        Route::get('check', [VerificationController::class, 'check'])->name('check');
        Route::get('resend_code', [VerificationController::class, 'resendCode'])->name('resend.code');
        Route::post('mail-verify', [VerificationController::class, 'mailVerify'])->name('mail.verify');
        Route::post('sms-verify', [VerificationController::class, 'smsVerify'])->name('sms.verify');
        Route::post('twoFA-Verify', [VerificationController::class, 'twoFAverify'])->name('twoFA-Verify');

        Route::middleware('userCheck')->group(function () {
            Route::middleware(['kyc'])->group(function () {
                Route::get('dashboard', [HomeController::class, 'index'])->name('dashboard');
                Route::get('get-transaction-chart', [HomeController::class, 'getTransactionChart'])->name('get.transaction.chart');
                Route::post('save-token', [HomeController::class, 'saveToken'])->name('save.token');

                /* ===== Manage Two Step ===== */
                Route::get('two-step-security', [TwoFaSecurityController::class, 'twoStepSecurity'])->name('twostep.security');
                Route::post('twoStep-enable', [TwoFaSecurityController::class, 'twoStepEnable'])->name('twoStepEnable');
                Route::post('twoStep-disable', [TwoFaSecurityController::class, 'twoStepDisable'])->name('twoStepDisable');
                Route::post('twoStep/re-generate', [TwoFaSecurityController::class, 'twoStepRegenerate'])->name('twoStepRegenerate');


                Route::group(['prefix' => 'ticket', 'as' => 'ticket.'], function () {
                    Route::get('/', [SupportTicketController::class, 'index'])->name('list');
                    Route::get('/create', [SupportTicketController::class, 'create'])->name('create');
                    Route::post('/create', [SupportTicketController::class, 'store'])->name('store');
                    Route::get('/view/{ticket}', [SupportTicketController::class, 'ticketView'])->name('view');
                    Route::put('/reply/{ticket}', [SupportTicketController::class, 'reply'])->name('reply');
                    Route::get('/download/{ticket}', [SupportTicketController::class, 'download'])->name('download');
                });

                //Store Management
                Route::group(['prefix' => 'store', 'as' => 'store.'], function () {
                    Route::get('/list', [StoreController::class, 'list'])->name('list');
                    Route::get('/create', [StoreController::class, 'create'])->name('create')->middleware('plan:store');
                    Route::post('/store', [StoreController::class, 'store'])->name('store');
                    Route::get('/edit/{id}', [StoreController::class, 'edit'])->name('edit')->middleware('plan:edit');
                    Route::put('/update/{id}', [StoreController::class, 'update'])->name('update');
                    Route::delete('/delete/{id}', [StoreController::class, 'delete'])->name('delete');
                    Route::post('/link/check', [StoreController::class, 'linkCheck'])->name('link.check');
                    Route::get('/qr-code/{store_id}', [StoreController::class, 'storeQRCode'])->name('qr.code');

                    Route::get('/schedule/{id?}', [StoreController::class, 'schedules'])->name('schedules');
                    Route::post('/schedule-update/{id?}', [StoreController::class, 'scheduleUpdate'])->name('schedule.update');

                    Route::any('/telegram-bot/{id}', [StoreController::class, 'telegramBot'])->name('telegram.set')->middleware('plan:telegram');
                    Route::get('/telegram-docs', [StoreController::class, 'telegramDocs'])->name('telegram.docs');
                    Route::any('/messenger-bot/{id}', [StoreController::class, 'messengerBot'])->name('messenger.set')->middleware('plan:messenger');
                    Route::get('/messenger-docs', [StoreController::class, 'messengerDocs'])->name('messenger.docs');
                    Route::any('/whatsapp-bot/{id}', [StoreController::class, 'whatsappBot'])->name('whatsapp.set')->middleware('plan:whatsapp');
                    Route::get('/whatsapp-docs', [StoreController::class, 'whatsappDocs'])->name('whatsapp.docs');

                    Route::get('/command-bot/{id}', [StoreController::class, 'commandBot'])->name('command.set');
                    Route::any('/command-bot/edit/{storeId}/{key}', [StoreController::class, 'commandBotEdit'])->name('command.edit');

                    Route::group(['prefix' => 'category', 'as' => 'category.'], function () {
                        Route::get('/index', [StoreCategoryController::class, 'index'])->name('index');
                        Route::post('/store', [StoreCategoryController::class, 'store'])->name('store');
                        Route::post('/update', [StoreCategoryController::class, 'update'])->name('update');
                        Route::delete('/delete/{id}', [StoreCategoryController::class, 'delete'])->name('delete');
                    });

                    Route::group(['prefix' => 'menu', 'as' => 'menu.'], function () {
                        Route::get('/index', [StoreProductController::class, 'index'])->name('index');
                        Route::any('/create', [StoreProductController::class, 'create'])->name('create')->middleware('plan:product');
                        Route::any('/edit/{id}', [StoreProductController::class, 'edit'])->name('edit');
                        Route::delete('/delete/{id}', [StoreProductController::class, 'delete'])->name('delete');

                        Route::get('/optional', [StoreProductOptionalController::class, 'index'])->name('optional.index');
                        Route::any('/optional/create', [StoreProductOptionalController::class, 'create'])->name('optional.create');
                        Route::any('/optional/edit/{id}', [StoreProductOptionalController::class, 'edit'])->name('optional.edit');
                        Route::delete('/optional/delete/{id}', [StoreProductOptionalController::class, 'delete'])->name('optional.delete');
                    });

                    Route::group(['prefix' => 'shipping', 'as' => 'shipping.'], function () {
                        Route::get('/index', [StoreShippingController::class, 'index'])->name('index');
                        Route::post('/store', [StoreShippingController::class, 'store'])->name('store');
                        Route::post('/update', [StoreShippingController::class, 'update'])->name('update');
                        Route::delete('/delete/{id}', [StoreShippingController::class, 'delete'])->name('delete');
                    });

                    Route::group(['prefix' => 'coupon', 'as' => 'coupon.'], function () {
                        Route::get('/index', [StoreCouponController::class, 'index'])->name('index');
                        Route::any('/create', [StoreCouponController::class, 'create'])->name('create');
                        Route::any('/edit/{id}', [StoreCouponController::class, 'edit'])->name('edit');
                        Route::delete('/delete/{id}', [StoreCouponController::class, 'delete'])->name('delete');
                    });
                });

                Route::group(['prefix' => 'order', 'as' => 'order.'], function () {
                    Route::get('/{stage?}', [OrderController::class, 'index'])->name('index');
                    Route::get('/details/{orderNumber}', [OrderController::class, 'details'])->name('details');
                    Route::post('/stage/change/{orderId}', [OrderController::class, 'singleStageChange'])->name('single.stage.change');
                    Route::post('/stage/change/', [OrderController::class, 'multipleStageChange'])->name('multiple.stage.change');
                });

                Route::group(['prefix' => 'payment-gateway', 'as' => 'payment.gateway.'], function () {
                    Route::get('/', [PaymentGatewayController::class, 'index'])->name('index');
                    Route::any('/edit/{id}', [PaymentGatewayController::class, 'edit'])->name('edit');
                    Route::delete('/delete/{id}', [PaymentGatewayController::class, 'delete'])->name('delete');
                    Route::post('sorting', [PaymentGatewayController::class, 'sortPaymentMethods'])->name('sort');
                });

                Route::get('/my-transactions', [TransactionController::class, 'index'])->name('transactions');
                Route::get('/purchase-plans', [PurchasePlanController::class, 'purchasePlanList'])->name('purchase.plan.list');

                Route::get('notification-permission', [NotificationPermissionController::class, 'notificationPermission'])->name('notification.permission');
                Route::put('notification-permission/update', [NotificationPermissionController::class, 'notificationPermissionUpdate'])->name('notification.permission.update');
            });

            /* ===== Push Notification ===== */
            Route::get('push-notification-show', [InAppNotificationController::class, 'show'])->name('push.notification.show');
            Route::get('push-notification-readAll', [InAppNotificationController::class, 'readAll'])->name('push.notification.readAll');
            Route::get('push-notification-readAt/{id}', [InAppNotificationController::class, 'readAt'])->name('push.notification.readAt');

            Route::get('verification/kyc', [KycVerificationController::class, 'kyc'])->name('verification.kyc');
            Route::get('verification/kyc-form/{id}', [KycVerificationController::class, 'kycForm'])->name('verification.kyc.form');
            Route::post('verification/kyc/submit', [KycVerificationController::class, 'verificationSubmit'])->name('kyc.verification.submit');
            Route::get('verification/kyc/history', [KycVerificationController::class, 'history'])->name('verification.kyc.history');

            Route::get('profile', [HomeController::class, 'profile'])->name('profile');
            Route::post('profile-update', [HomeController::class, 'profileUpdate'])->name('profile.update');
            Route::post('profile-update/image', [HomeController::class, 'profileUpdateImage'])->name('profile.update.image');
            Route::post('update/password', [HomeController::class, 'updatePassword'])->name('updatePassword');

            Route::get('/purchase-plan/{plan_schedule_id}/{type?}/{purchase_id?}', [PurchasePlanController::class, 'purchasePlan'])->name('purchase.plan');

        });
    });


    Route::get('captcha', [ManualRecaptchaController::class, 'reCaptCha'])->name('captcha');

    /* Manage User Deposit */
    Route::get('supported-currency', [DepositController::class, 'supportedCurrency'])->name('supported.currency');
    Route::post('payment-request', [DepositController::class, 'paymentRequest'])->name('payment.request');
    Route::get('deposit-check-amount', [DepositController::class, 'checkAmount'])->name('deposit.checkAmount');
    Route::get('deposit-check-convert-amount', [DepositController::class, 'checkConvertAmount'])->name('deposit.checkConvertAmount');

    Route::get('payment-process/{trx_id}', [PaymentController::class, 'depositConfirm'])->name('payment.process');
    Route::post('addFundConfirm/{trx_id}', [PaymentController::class, 'fromSubmit'])->name('addFund.fromSubmit');
    Route::match(['get', 'post'], 'success', [PaymentController::class, 'success'])->name('success');
    Route::match(['get', 'post'], 'failed', [PaymentController::class, 'failed'])->name('failed');

    Route::post('khalti/payment/verify/{trx}', [\App\Http\Controllers\khaltiPaymentController::class, 'verifyPayment'])->name('khalti.verifyPayment');
    Route::post('khalti/payment/store', [khaltiPaymentController::class, 'storePayment'])->name('khalti.storePayment');

    Route::get('blog/{slug}', [BlogController::class, 'blogDetails'])->name('blog.details');

    Route::post('/contact', [CommonController::class, 'contactSend'])->name('contact.send');
    Route::post('/subscribe', [CommonController::class, 'subscribe'])->name('subscribe');

    Route::get('/cookie-policy', [CommonController::class, 'cookiePolicy'])->name('cookie-policy');

    //Social Login
    Route::get('auth/{socialite}', [SocialiteController::class, 'socialiteLogin'])->name('socialiteLogin');
    Route::get('auth/callback/{socialite}', [SocialiteController::class, 'socialiteCallback'])->name('socialiteCallback');

    /* Public Store */
    Route::get('{senderId}/store/menu/{link?}/{categoryId?}/{bot_type?}', [StoreShopController::class, 'shopProduct'])->name('public.view');
    Route::get('{senderId}/store/menu/{link}/details/{title}/{id}/{bot_type?}', [StoreShopController::class, 'shopProductDetails'])->name('public.product.details');
    Route::get('{senderId}/update/{link}/{title}/{id}', [StoreShopController::class, 'shopCartUpdate'])->name('public.product.update');
    Route::post('add-cart', [StoreShopController::class, 'addCart'])->name('public.add.cart');
    Route::post('update-cart/details', [StoreShopController::class, 'updateCartDetails'])->name('public.update.cartDetails');
    Route::post('remove-cart', [StoreShopController::class, 'removeCart'])->name('public.remove.cart');
    Route::post('update-cart', [StoreShopController::class, 'updateCart'])->name('public.update.cart');
    Route::get('{senderId}/cart/item/{link}', [StoreShopController::class, 'cartItem'])->name('public.cart.item');
    Route::any('{senderId}/shipping/details/{link}', [CheckoutController::class, 'shipping'])->name('public.shipping');
    Route::get('{senderId}/checkout/{link}/{utr}', [CheckoutController::class, 'checkout'])->name('public.checkout');
    Route::post('promo-apply', [CheckoutController::class, 'promoApply'])->name('public.promo.apply');
    Route::post('payment', [CheckoutController::class, 'payment'])->name('public.payment');

    Route::get('order-supported-currency', [CheckoutController::class, 'orderSupportedCurrency'])->name('order.supported.currency');
    Route::get('order-check-convert-amount', [CheckoutController::class, 'orderCheckConvertAmount'])->name('order.checkConvertAmount');

    Route::get('download-pdf/ok/abc/cde/efg/addf/{id}', [HomeController::class, 'downloadPDF'])->name('downloadPdf');
    Route::get('sendPdf//ok/abc/cde/efg/addf/eee/dddd/eeee/dddd/{order}', [HomeController::class, 'sendPdf'])->name('sendPdf');


    Auth::routes();
    /*= Frontend Manage Controller =*/
    Route::get("/{slug?}", [FrontendController::class, 'page'])->name('page')->middleware('track.visitors');
});


