@extends(template().'layouts.user')
@section('page_title',__('Edit Gateway'))

@section('content')
	<div class="container-fluid">
		<div class="main row">
			<div class="col-12">
				<div class="dashboard-heading">
					<h2 class="mb-0">@lang('Edit Gateway - '.$gateway->name)</h2>
				</div>
				<section class="profile-setting">
					<div class="sidebar-wrapper">
						<form action="{{ route('user.payment.gateway.edit',$gateway->id) }}" method="post" enctype="multipart/form-data">
							@csrf
                            @method('PUT')
							<div class="row">
                                <div class="col-lg-6 mb-3">
                                    <div class="input-box form-group">
                                        <label for="Attribute Name">@lang('Gateway Name')</label>
                                        <input type="text" value="{{ $gateway->name }}"
                                               name="name"
                                               class="form-control @error('name') is-invalid @enderror"
                                               autocomplete="off" required>
                                        <div class="invalid-feedback d-block">
                                            @error('name') @lang($message) @enderror
                                        </div>
                                    </div>
                                </div>

                                @if($gateway->currencies)
                                    <div class="col-lg-6 mb-2">
                                        <div class="input-box form-group">
                                            <label for="Store">@lang('Supported Currency')</label>
                                            <select name="receivable_currencies[][name]"
                                                    class="supported_currency form-control @error('extra_products') is-invalid @enderror"
                                                    multiple="multiple">
                                                @php
                                                    $paymentMethodsCurrency = session()->has('selectedCurrencyList')
                                                        ? session('selectedCurrencyList')
                                                        : (isset($gateway->supported_currency) ? $gateway->supported_currency : []);
                                                @endphp
                                                @forelse($gateway->currencies as $key => $currency)
                                                    @foreach($currency as $curKey => $singleCurrency)
                                                        @php
                                                            $isSelected = in_array($curKey, (array) $paymentMethodsCurrency);
                                                        @endphp
                                                        <option
                                                            value="{{ $curKey }}" {{ $isSelected ? 'selected' : '' }}>
                                                            {{ trans($curKey) }}
                                                        </option>
                                                    @endforeach
                                                @empty
                                                @endforelse
                                            </select>
                                            <div class="invalid-feedback d-block">
                                                @error('receivable_currencies.0.name') @lang($message) @enderror
                                            </div>
                                        </div>
                                    </div>
                                @endif

                                @foreach ($gateway->parameters as $key => $parameter)
                                    <div class="col-lg-6 mb-3">
                                        <div class="input-box form-group">
                                            <label for="{{ $key }}">@lang(snake2Title($key))</label>
                                            <input type="text" value="{{ old($key, $parameter) }}"
                                                   name="{{ $key }}" id="{{ $key }}"
                                                   class="form-control @error($key) is-invalid @enderror"
                                                   autocomplete="off" required>
                                            <div class="invalid-feedback d-block">
                                                @error($key) @lang($message) @enderror
                                            </div>
                                        </div>
                                    </div>
                                @endforeach

                                @if($gateway->extra_parameters)
                                    @foreach($gateway->extra_parameters as $key => $param)
                                        <div class="col-lg-6 mb-3">
                                            <div class="input-box form-group">
                                                <label for="{{ $key }}">@lang(snake2Title($key))</label>
                                                <div class="input-group">
                                                    <input type="text" value="{{ old($key, route($param, $gateway->code )) }}"
                                                           name="{{ $key }}" id="{{ $key }}"
                                                           class="form-control copyUrl @error($key) is-invalid @enderror"
                                                           autocomplete="off" readonly>
                                                    <button class="btn-modify py-0 copytext" type="button"
                                                            id="copyBoard"
                                                            onclick="copyFunction()"><i
                                                            class="fa fa-clipboard"></i>
                                                    </button>
                                                </div>
                                                <div class="invalid-feedback d-block">
                                                    @error($key) @lang($message) @enderror
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                @endif

                                <div class="col-md-12 mb-3">
                                    <div class="input-box form-group">
                                        <label
                                            for="Description">@lang('Description')</label>
                                        <textarea
                                            class="form-control summernote h-100"
                                            name="description"
                                            rows="3">{{$gateway->description}}</textarea>
                                        <div class="invalid-feedback d-block">
                                            @error('description') @lang($message) @enderror
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-lg-4">
                                        <div class="form-group position-relative">
                                            <div class="image-input z0">
                                                <label for="image-upload" id="image-label"><i
                                                        class="fas fa-upload"></i></label>
                                                <input type="file" id="image" name="image"
                                                       placeholder="@lang('Choose image')"
                                                       class="image-preview">
                                                <img id="image_preview_container" class="preview-image"
                                                     src="{{ getFile($gateway->driver,$gateway->image) }}"
                                                     alt="@lang('preview image')">
                                            </div>
                                        </div>
                                        <div class="invalid-feedback d-block">
                                            @error('image') @lang($message) @enderror
                                        </div>
                                    </div>
                                    <div class="col-lg-8">
                                        <label class="mt-5">@lang('Status')</label>
                                        <div class="selectgroup w-100">
                                            <label class="selectgroup-item">
                                                <input type="radio" name="is_active"
                                                       value="0"
                                                       class="selectgroup-input" {{$gateway->status == 0 ? 'checked':''}}>
                                                <span class="selectgroup-button">@lang('OFF')</span>
                                            </label>
                                            <label class="selectgroup-item">
                                                <input type="radio" name="is_active"
                                                       value="1"
                                                       class="selectgroup-input" {{$gateway->status == 1 ? 'checked':''}}>
                                                <span class="selectgroup-button">@lang('ON')</span>
                                            </label>
                                        </div>

                                        <label class="mt-5">@lang('Test Environment')</label>
                                        <div class="selectgroup w-100">
                                            <label class="selectgroup-item">
                                                <input type="radio" name="test_environment"
                                                       value="live"
                                                       class="selectgroup-input" {{$gateway->environment == 'live' ? 'checked' : ''}}>
                                                <span class="selectgroup-button">@lang('OFF')</span>
                                            </label>
                                            <label class="selectgroup-item">
                                                <input type="radio" name="test_environment"
                                                       value="test"
                                                       class="selectgroup-input" {{$gateway->environment == 'test' ? 'checked' : ''}}>
                                                <span class="selectgroup-button">@lang('ON')</span>
                                            </label>
                                        </div>
                                    </div>
                                </div>

                                <div class="supported_currency_card mt-lg-5">
                                    <h4 class="card-header-title">@lang('Supported Currencies Configuration')</h4>
                                    <div class="table-parent table-responsive">
                                        <table class="table table-striped" id="supported_currency_table">
                                            <thead class="thead-light">
                                            <tr>
                                                <th scope="col">@lang('Currency Symbol')</th>
                                                <th scope="col">@lang('Conversion Rate')</th>
                                                <th scope="col">@lang('Min Limit')</th>
                                                <th scope="col">@lang('Max Limit')</th>
                                                <th scope="col">@lang('Percentage Charge')</th>
                                                <th scope="col">@lang('Fixed Charge')</th>
                                            </tr>
                                            </thead>
                                            <tbody class="add_table_row">
                                            @php
                                                $oldReceivableCurrency = old('receivable_currencies', $gateway->receivable_currencies) ? count(old('receivable_currencies', $gateway->receivable_currencies)) : 0;
                                                $oldSelectedCurrency = session()->get('selectedCurrencyList');
                                            @endphp
                                            @if($oldReceivableCurrency > 0)
                                                @for($i = 0; $i < $oldReceivableCurrency; $i++)
                                                    <tr class="{{ $oldSelectedCurrency[$i] ?? $gateway->receivable_currencies[$i]->name }}-row">
                                                        <td>
                                                            <div class="input-box mb-1">
                                                                <input type="text" class="form-control"
                                                                       name="receivable_currencies[{{ $i }}][currency_symbol]"
                                                                       placeholder="Currency Symbol"
                                                                       aria-label="Currency Symbol"
                                                                       value="{{ old("receivable_currencies.$i.currency_symbol",  $gateway->receivable_currencies[$i]->name ?? '') }}"
                                                                       autocomplete="off">
                                                                @error("receivable_currencies.$i.currency_symbol")
                                                                <span
                                                                    class="invalid-feedback d-block mb-1">{{ $message }}</span>
                                                                @enderror
                                                            </div>
                                                        </td>

                                                        <td>
                                                            <div class="input-box input-group mb-1">
                                                                <span class="input-group-text form-control bg-transparent"> 1 {{ $basicControl->base_currency ? : 'USD' }} = </span>
                                                                <input type="text"
                                                                       class="form-control bg-transparent @error('conversion_rate') is-invalid @enderror"
                                                                       name="receivable_currencies[{{ $i }}][conversion_rate]"
                                                                       value="{{ old("receivable_currencies.$i.conversion_rate", $gateway->receivable_currencies[$i]->conversion_rate ?? '') }}"
                                                                       autocomplete="off">
                                                                <span
                                                                    class="input-group-text form-control bg-transparent">{{ old("receivable_currencies.$i.name", $gateway->currency_type == 1 ? $gateway->receivable_currencies[$i]->name : 'USD') }}</span>
                                                                @error("receivable_currencies.$i.conversion_rate")
                                                                <span
                                                                    class="invalid-feedback d-block mb-1">{{ $message }}</span>
                                                                @enderror
                                                            </div>
                                                        </td>

                                                        <td>
                                                            <div class="input-box input-group mb-1">
                                                                <input type="text"
                                                                       class="form-control bg-transparent @error('min_limit') is-invalid @enderror"
                                                                       name="receivable_currencies[{{ $i }}][min_limit]"
                                                                       aria-label="Amount (to the nearest dollar)"
                                                                       value="{{ old("receivable_currencies.$i.min_limit", $gateway->receivable_currencies[$i]->min_limit ?? '')  }}"
                                                                       autocomplete="off">
                                                                <span
                                                                    class="input-group-text form-control bg-transparent">{{ old("receivable_currencies.$i.name", $gateway->currency_type == 1 ? $gateway->receivable_currencies[$i]->name : "USD") }}</span>
                                                                @error("receivable_currencies.$i.min_limit")
                                                                <span
                                                                    class="invalid-feedback d-block mb-1">{{ $message }}</span>
                                                                @enderror
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <div class="input-box input-group mb-1">
                                                                <input type="text"
                                                                       class="form-control bg-transparent @error('max_limit') is-invalid @enderror"
                                                                       name="receivable_currencies[{{$i}}][max_limit]"
                                                                       aria-label="Amount"
                                                                       value="{{ old("receivable_currencies.$i.max_limit", $gateway->receivable_currencies[$i]->max_limit ?? '') }}"
                                                                       autocomplete="off">
                                                                <span
                                                                    class="input-group-text form-control bg-transparent">{{ old("receivable_currencies.$i.name", $gateway->currency_type == 1 ? $gateway->receivable_currencies[$i]->name : "USD") }}</span>
                                                                @error("receivable_currencies.$i.max_limit")
                                                                <span
                                                                    class="invalid-feedback d-block mb-1">{{ $message }}</span>
                                                                @enderror
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <div class="input-box input-group mb-1">
                                                                <input type="text"
                                                                       class="form-control bg-transparent @error('percentage_charge') is-invalid @enderror"
                                                                       name="receivable_currencies[{{ $i }}][percentage_charge]"
                                                                       aria-label="Amount (to the nearest dollar)"
                                                                       value="{{ old("receivable_currencies.$i.percentage_charge", $gateway->receivable_currencies[$i]->percentage_charge ?? "") }}"
                                                                       autocomplete="off">
                                                                <span
                                                                    class="input-group-text form-control bg-transparent">%</span>
                                                                @error("receivable_currencies.$i.percentage_charge")
                                                                <span
                                                                    class="invalid-feedback d-block mb-1">{{ $message }}</span>
                                                                @enderror
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <div class="input-box input-group mb-1">
                                                                <input type="text"
                                                                       class="form-control bg-transparent @error('fixed_charge') is-invalid @enderror"
                                                                       name="receivable_currencies[{{ $i }}][fixed_charge]"
                                                                       aria-label="Amount (to the nearest dollar)"
                                                                       value="{{ old("receivable_currencies.$i.fixed_charge", $gateway->receivable_currencies[$i]->fixed_charge ?? '') }}"
                                                                       autocomplete="off">
                                                                <span
                                                                    class="input-group-text form-control bg-transparent">{{ old("receivable_currencies.$i.name", $gateway->currency_type == 1 ? $gateway->receivable_currencies[$i]->name : "USD") }}</span>
                                                                @error("receivable_currencies.$i.fixed_charge")
                                                                <span
                                                                    class="invalid-feedback d-block mb-1">{{ $message }}</span>
                                                                @enderror
                                                            </div>
                                                        </td>
                                                    </tr>
                                                @endfor
                                            @endif
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
							</div>
							<button type="submit" class="btn-custom mt-3">@lang('Save Changes')</button>
						</form>
					</div>
				</section>
			</div>
		</div>
	</div>
@endsection


@push('css-lib')
    <link rel="stylesheet" href="{{ asset($themeTrue.'/css/bootstrap-select.min.css') }}">
@endpush
@push('js-lib')
    <script src="{{ asset($themeTrue.'/js/bootstrap-select.min.js') }}"></script>
@endpush

@push('script')
    <script>
        'use strict';
        $(document).ready(function () {
            $(".supported_currency").select2({
                width: '100%',
                minimumResultsForSearch: -1,
                placeholder: '@lang("Select Currency")',
            });

            var eventHandler = function (name) {
                return function (e) {
                    if (name == 'onItemAdd') {
                        itemAppend(e.params.data.id);
                    } else if (name == 'onItemRemove') {
                        itemRemove(e.params.data.id);
                    }
                };
            };

            $(".supported_currency").on('select2:select', eventHandler('onItemAdd'));
            $(".supported_currency").on('select2:unselect', eventHandler('onItemRemove'));
        });

        $(document).on('change', '.image-preview', function () {
            let reader = new FileReader();
            reader.onload = (e) => {
                $('#image_preview_container').attr('src', e.target.result);
            }
            reader.readAsDataURL(this.files[0]);
        });

        function copyFunction() {
            var copyText = document.querySelector(".copyUrl");
            copyText.select();
            copyText.setSelectionRange(0, 99999);
            /*For mobile devices*/
            document.execCommand("copy");
            Notiflix.Notify.success(`Copied: ${copyText.value}`);
        }

        let gateway = @json($gateway);
        function itemAppend(currency) {
            let rowCount = $('#supported_currency_table tr').length;
            currency = gateway.currency_type === 1 ? currency : 'USD';
            let markup = "";
            markup += `
                        <tr class="${currency}-row">
                                <td>
                                    <div class="input-box">
                                        <input type="text" class="form-control" name="receivable_currencies[${rowCount - 1}][currency_symbol]"
                                           placeholder="@lang("Currency Symbol")" aria-label="@lang("Currency Symbol")"
                                           autocomplete="off">
                                    </div>
                                </td>
                                <td>
                                    <div class="input-box input-group">
                                        <span class="input-group-text form-control bg-transparent">1 {{ $basicControl->base_currency }} = </span>
                                        <input type="text"
                                            class="form-control bg-transparent"
                                            name="receivable_currencies[${rowCount - 1}][conversion_rate]"
                                            autocomplete="off">
                                            <span class="input-group-text form-control bg-transparent">${currency}</span>
                                    </div>
                                </td>
                                <td>
                                    <div class="input-box input-group">
                                        <input type="text" class="form-control bg-transparent"
                                          name="receivable_currencies[${rowCount - 1}][min_limit]"
                                          autocomplete="off">
                                          <span class="input-group-text form-control bg-transparent">${currency}</span>
                                    </div>
                                </td>
                                <td>
                                    <div class="input-box input-group">
                                        <input type="text" class="form-control bg-transparent"
                                            name="receivable_currencies[${rowCount - 1}][max_limit]"
                                            autocomplete="off">
                                            <span class="input-group-text form-control bg-transparent">${currency}</span>
                                    </div>
                                </td>
                                <td>
                                    <div class="input-box input-group">
                                        <input type="text" class="form-control bg-transparent"
                                            name="receivable_currencies[${rowCount - 1}][percentage_charge]"
                                            autocomplete="off">
                                            <span class="input-group-text form-control bg-transparent">%</span>
                                    </div>
                                </td>
                                <td>
                                    <div class="input-box input-group">
                                        <input type="text" class="form-control bg-transparent"
                                             name="receivable_currencies[${rowCount - 1}][fixed_charge]"
                                             autocomplete="off">
                                             <span class="input-group-text form-control bg-transparent">${currency}</span>
                                    </div>
                                </td>

                        </tr>`;

            $('.add_table_row').append(markup);
        }

        function itemRemove(currency) {
            $(`.${currency}-row`).remove();
            alignArrayIndexForSupportCurrency();
        }


        function alignArrayIndexForSupportCurrency() {
            $('.add_table_row tr').each(function (index) {
                $(this).find('input[name^="receivable_currencies"]').each(function () {
                    var newName = $(this).attr('name').replace(/\[(\d+)\]/, '[' + index + ']');
                    $(this).attr('name', newName);
                })
            })
        }
    </script>
@endpush
