@extends(template().'layouts.user')
@section('page_title',__('Transactions'))

@section('content')
	<div class="container-fluid">
		<div class="main row">
			<div class="col-12">
				<div class="dashboard-heading">
					<h2 class="mb-0">@lang('Transactions')</h2>
                    <button type="button" class="btn-custom customButton" id="customOffcanvasBtn"><i class="fal fa-filter"></i>@lang('Filter')</button>
				</div>
				<div class="table-parent table-responsive">
					<table class="table table-striped">
						<thead>
						<tr>
							<th scope="col">@lang('Transaction ID')</th>
							<th scope="col">@lang('Gateway')</th>
							<th scope="col">@lang('Amount')</th>
							<th scope="col">@lang('Charge')</th>
							<th scope="col">@lang('Type')</th>
							<th scope="col">@lang('Status')</th>
							<th scope="col">@lang('Created time')</th>
                            <th scope="col">@lang('Action')</th>
						</tr>
						</thead>
						<tbody>
						@forelse($transactions as $key => $value)
							<tr>
                                <td data-label="@lang('Transaction ID')">{{ __($value->trx_id) }}</td>
                                <td data-label="@lang('Gateway')">
                                    <div class="d-lg-flex align-items-center text-end text-md-start">
                                        <div class="mr-3">
                                            @php
                                            if($value->transactional == \App\Models\Order::class){
                                                $gatewayImage = getFile(optional(optional($value->transactional)->userGateway)->driver, optional(optional($value->transactional)->userGateway)->image);
                                                $gatewayName = optional(optional($value->transactional)->userGateway)->name;
                                            }else{
                                                $gatewayImage = getFile(optional(optional($value->transactional)->gateway)->driver, optional(optional($value->transactional)->gateway)->image);
                                                $gatewayName = optional(optional($value->transactional)->gateway)->name;
                                            }
                                            @endphp
                                            <img src="{{ $gatewayImage }}" alt="user" class="rounded-circle" width="40" height="40">
                                        </div>
                                        <div class="d-inline-flex d-lg-block align-items-center ms-2">
                                            <p class="text-dark mb-0 font-16 font-weight-medium">@lang($gatewayName)</p>
                                        </div>
                                    </div>
                                </td>
								<td data-label="@lang('Amount')">{{ currencyPosition(getAmount($value->amount)) }}</td>
                                <td data-label="@lang('Charge')">{{ currencyPosition(getAmount($value->charge)) }}</td>
								<td data-label="@lang('Type')">
									{{ __($value->transactional_type == \App\Models\PurchasePlan::class ? "Purchase Plan"
                                        : ($value->transactional_type == \App\Models\Order::class ? "Order" : ($value->transactional_type == \App\Models\Payout::class ? "Withdraw" : '')) ) }}
								</td>
								<td data-label="@lang('Status')">
                                    @if($value->transactional_type == \App\Models\PurchasePlan::class || $value->transactional_type == \App\Models\Order::class)
                                        @if(optional(optional($value->transactional)->deposit)->status == 1)
                                            <span class="badge bg-success">@lang('Completed')</span>
                                        @elseif(optional(optional($value->transactional)->deposit)->status == 2)
                                            <span class="badge bg-warning">@lang('Requested')</span>
                                        @elseif(optional(optional($value->transactional)->deposit)->status == 3)
                                            <span class="badge bg-danger">@lang('Rejected')</span>
                                        @else
                                            <span class="badge bg-warning">@lang('Pending')</span>
                                        @endif
                                    @elseif($value->transactional_type == \App\Models\Payout::class)
                                        @if(optional($value->transactional)->status == 1)
                                            <span class="badge bg-info">@lang('Generated')</span>
                                        @elseif(optional($value->transactional)->status == 2)
                                            <span class="badge bg-success">@lang('success')</span>
                                        @elseif(optional($value->transactional)->status == 3)
                                            <span class="badge bg-danger">@lang('Canceled')</span>
                                        @else
                                            <span class="badge bg-warning">@lang('Pending')</span>
                                        @endif
                                    @endif
								</td>
								<td data-label="@lang('Created time')"> {{ dateTime($value->created_at)}} </td>
                                <td data-label="Action">
                                    @if($value->transactional_type == \App\Models\PurchasePlan::class || $value->transactional_type == \App\Models\Order::class)
                                        @if(optional(optional($value->transactional)->gateway)->id > 999)
                                            @php
                                                $details = null;
                                                if (optional(optional($value->transactional)->deposit)->information) {
                                                    $details = [];
                                                    foreach (optional(optional($value->transactional)->deposit)->information as $k => $v) {
                                                        if ($v->type == "file") {
                                                            $details[kebab2Title($k)] = [
                                                                'type' => $v->type,
                                                                'field_name' => $v->field_name,
                                                                'field_value' => getFile($v->field_driver, $v->field_value),
                                                            ];
                                                        } else {
                                                            $details[kebab2Title($k)] = [
                                                                'type' => $v->type,
                                                                'field_name' => $v->field_name,
                                                                'field_value' => @$v->field_value ?? $v->field_name
                                                            ];
                                                        }
                                                    }
                                                }
                                            @endphp
                                            <div class="sidebar-dropdown-items">
                                                <button
                                                    type="button"
                                                    class="dropdown-toggle"
                                                    data-bs-toggle="dropdown"
                                                    aria-expanded="false">
                                                    <i class="fal fa-cog"></i>
                                                </button>
                                                <ul class="dropdown-menu dropdown-menu-end">
                                                    <li>
                                                        <a href="javascript:void(0)" class="dropdown-item detailsModal"
                                                           data-bs-toggle="modal"
                                                           data-detailsinfo = "{{ json_encode($details) }}"
                                                           data-bs-target="#detailsModal" data-resource="{{$value}}"> <i class="fal fa-eye"></i> @lang('Details') </a>
                                                    </li>
                                                </ul>
                                            </div>
                                        @else
                                            --
                                        @endif
                                    @elseif($value->transactional_type == \App\Models\Payout::class)
                                        @php
                                            $details = null;
                                            if (optional($value->transactional)->information) {
                                                $details = [];
                                                foreach (optional($value->transactional)->information as $k => $v) {
                                                    if ($v->type == "file") {
                                                        $details[kebab2Title($k)] = [
                                                            'type' => $v->type,
                                                            'field_name' => $v->field_name,
                                                            'field_value' => getFile($v->field_driver, $v->field_value),
                                                        ];
                                                    } else {
                                                        $details[kebab2Title($k)] = [
                                                            'type' => $v->type,
                                                            'field_name' => $v->field_name,
                                                            'field_value' => @$v->field_value ?? $v->field_name
                                                        ];
                                                    }
                                                }
                                            }
                                        @endphp
                                        <div class="sidebar-dropdown-items">
                                            <button
                                                type="button"
                                                class="dropdown-toggle"
                                                data-bs-toggle="dropdown"
                                                aria-expanded="false">
                                                <i class="fal fa-cog"></i>
                                            </button>
                                            <ul class="dropdown-menu dropdown-menu-end">
                                                <li>
                                                    <a href="javascript:void(0)" class="dropdown-item detailsModal"
                                                       data-bs-toggle="modal"
                                                       data-detailsinfo = "{{ json_encode($details) }}"
                                                       data-bs-target="#detailsModal" data-resource="{{$value}}"> <i class="fal fa-eye"></i> @lang('Details') </a>
                                                </li>
                                            </ul>
                                        </div>
                                    @endif
                                </td>
							</tr>
						@empty
                            <tr class="text-center">
                                <th class="text-center" colspan="100%">
                                    <img class="noDataImg" src="{{ asset('assets/admin/img/oc-error-light.svg') }}" alt="image">
                                    <p class="mt-3">@lang('No data available')</p>
                                </th>
                            </tr>
						@endforelse
						</tbody>
					</table>
				</div>
				<nav aria-label="Page navigation example">
					<ul class="pagination justify-content-center">
                        {{ $transactions->appends($_GET)->links(template().'partials.pagination') }}
					</ul>
				</nav>
			</div>
		</div>
	</div>

    <div class="modal fade" id="detailsModal" tabindex="-1" aria-labelledby="detailsModal" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-md">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="detailsModal">@lang('Payment Information')</h5>
                    <button type="button" class="close-btn" data-bs-dismiss="modal" aria-label="Close">
                        <i class="fal fa-times"></i>
                    </button>
                </div>
                <form action="" method="GET" class="fromAction">
                    <div class="modal-body">
                        <div class="row g-4">
                            <ul class="list-group payment_information">
                                <li class="d-flex justify-content-between list-group-item">
                                    @lang('Amount paid')<span class="amount"></span>
                                </li>
                                <li class="d-flex justify-content-between list-group-item">
                                    @lang('Payment Date')<span class="paymentDate"></span>
                                </li>
                                <li class="d-flex justify-content-between list-group-item">
                                    @lang('Payment method')<span class="paymentMethod"></span>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn-custom btn2" data-bs-dismiss="modal">@lang('Close')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>


    <div class="custom-offcanvas end ">
        <div class="custom-offcanvas-header">
            <h4 class="custom-offcanvas-title mb-0">@lang('Filter')</h4>
            <button type="button" class="cmn-btn-close" data-bs-dismiss="offcanvas" aria-label="Close">
                <i class="fas fa-times"></i>
            </button>
        </div>
        <div class="custom-offcanvas-body">
            <div class="search-bar canvas_input_box">
                <form action="" method="get">
                    <div class="row g-3 align-items-end">
                        <div class="input-box col-lg-12">
                            <input placeholder="@lang('Transaction ID')" name="trx_id" value="{{ request()->trx_id ?? '' }}" type="text"
                                   class="form-control form-control-sm">
                        </div>
                        <div class="input-box col-lg-12">
                            <input placeholder="@lang('Transaction Date')" name="created_at" id="created_at"
                                   value="{{ request()->created_at ?? '' }}" type="date" class="form-control form-control-sm"
                                   autocomplete="off">
                        </div>
                        <div class="input-box col-lg-12">
                            <div class="form-group search-currency-dropdown">
                                <select name="type" class="form-select" aria-label="Default select example">
                                    <option value="">@lang('All Type')</option>
                                    <option  value="{{ \App\Models\PlanSchedule::class }}" {{ isset(request()->type) && request()->type == \App\Models\PlanSchedule::class ? 'selected' : '' }}>@lang('Purchase Plan')</option>
                                    <option value="{{ \App\Models\Order::class }}" {{ isset($search['type']) && $search['type'] == \App\Models\Order::class ? 'selected' : '' }}>@lang('Order')</option>
                                </select>
                            </div>
                        </div>
                        <div class="input-box col-lg-12">
                            <button type="submit" class="btn-custom w-100"><i class="fal fa-search"></i> @lang('Filter')</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

@push('script')
    <script>
        'use strict'
        $(document).on("click", ".detailsModal", function () {
            $('.clearList').remove();
            let res = $(this).data('resource');
            let payoutModel = @json('App\Models\Payout');
            let base_currency = "{{ basicControl()->base_currency }}";

            $('.paymentDate').text(new Date(res.created_at).toDateString());
            let details = Object.entries($(this).data('detailsinfo'));
            let list = details.map(([key, value]) => {
                let field_name = value.field_name;
                let field_value = value.field_value;
                let field_name_text = field_name.replace(/_/g, ' ');

                if (value.type == 'file') {
                    return `<li class="list-group-item d-flex align-items-center justify-content-between clearList">
                                ${field_name_text}
                                <a href="${field_value}" target="_blank"><img src="${field_value}" alt="Image Description" class="rounded-1" width="80px" height="60px"></a>
                            </li>`;
                } else {
                    return `<li class="d-flex justify-content-between align-items-center list-group-item clearList">
                                ${field_name_text}<span>${field_value}</span>
                            </li>`;
                }
            })
            if(res.transactional_type == payoutModel){
                $('.amount').text(`${parseFloat(res.transactional.amount_in_base_currency).toFixed(2)} ${base_currency}`);
                $('.paymentMethod').text(res.transactional.method.name);

                $('.payment_information').append(list);
                let feedbackField = `<li class="list-group-item clearList">
                                @lang('Feedback')<textarea class="form-control bg-transparent" rows="3" readonly>${res.transactional.feedback}</textarea>
                            </li>`;

                if (res.transactional.feedback != '' || res.transactional.feedback != null) {
                    $('.payment_information').append(feedbackField);
                }
            }else{
                $('.amount').text(`${parseFloat(res.transactional.deposit.payable_amount_in_base_currency).toFixed(2)} ${base_currency}`);
                $('.paymentMethod').text(res.transactional.gateway.name);

                $('.payment_information').append(list);
                let feedbackField = `<li class="list-group-item clearList">
                                @lang('Feedback')<textarea class="form-control bg-transparent" rows="3" readonly>${res.transactional.deposit.note}</textarea>
                            </li>`;

                if (res.transactional.deposit.note != '' || res.transactional.deposit.note != null) {
                    $('.payment_information').append(feedbackField);
                }
            }
        });
    </script>
@endpush

