@extends(template().'layouts.user')
@section('page_title',__('Update Coupon'))

@section('content')
	<div class="container-fluid">
		<div class="main row">
			<div class="col-12">
				<div class="dashboard-heading">
					<h2 class="mb-0">@lang('Update Coupon')</h2>
				</div>
				<section class="profile-setting">
					<div class="sidebar-wrapper">
						<form action="{{ route('user.store.coupon.edit',$coupon->id) }}" method="post"
							  enctype="multipart/form-data">
							@csrf
							<div class="d-flex justify-content-end">
								@if($coupon->end_date > \Illuminate\Support\Carbon::now())
									<span class="badge bg-success">@lang('Running')</span>
								@else
									<span class="badge bg-danger">@lang('Expired')</span>
								@endif
							</div>
							<div class="row mb-3">
								<div class="col-md-12 input-box">
									<label>@lang('Store')</label>
									<div class="form-group">
										<select class="form-select" name="store" required>
											<option value="" disabled selected>@lang('Select Store')</option>
											@if($stores)
												@foreach($stores as $store)
													<option
														value="{{$store->id}}" {{$coupon->store_id == $store->id ? 'selected':''}}>{{$store->name}}</option>
												@endforeach
											@endif
										</select>
										<div class="text-danger">
											@error('store') @lang($message) @enderror
										</div>
									</div>
								</div>
							</div>
							<div class="row mb-3">
								<div class="col-md-6">
									<div class="input-box form-group">
										<label for="Coupon Code">@lang('Coupon Code')</label>
										<div class="input-group">
											<input type="text"
												   name="code"
												   value="{{ $coupon->code }}"
												   class="form-control code"
												   placeholder="@lang('Code')"
												   autocomplete="off" required>
											<button type="button" class="btn-modify" id="generate">
												<span class="">@lang('Generate')</span>
											</button>
										</div>
										<div class="text-danger">
											@error('code') @lang($message) @enderror
										</div>
									</div>
								</div>
								<div class="col-md-6">
									<div class="input-box form-group">
										<label for="Minimum Order">@lang('Minimum Order')</label>
										<div class="input-group">
											<input type="number" step="0.001"
												   name="min_order"
												   value="{{ $coupon->min_order }}"
												   class="form-control"
												   placeholder="@lang('Min Order')"
												   autocomplete="off" required>
											<button type="button" class="btn-modify">
												<span class="">{{ basicControl()->base_currency }}</span>
											</button>
										</div>
										<div class="text-danger">
											@error('min_order') @lang($message) @enderror
										</div>
									</div>
								</div>
							</div>
							<div class="row mb-3">
								<div class="col-md-6">
									<div class="input-box form-group">
										<label for="Start Date">@lang('Start Date')</label>
										<input type="date"
											   name="start_date"
											   min="{{\Carbon\Carbon::now()->toDateString()}}"
											   value="{{\Illuminate\Support\Carbon::parse($coupon->start_date)->format('Y-m-d')}}"
											   class="form-control"
											   autocomplete="off" required>
										<div class="text-danger">
											@error('start_date') @lang($message) @enderror
										</div>
									</div>
								</div>
								<div class="col-md-6">
									<div class="input-box form-group">
										<label for="End Date">@lang('End Date')</label>
										<input type="date"
											   name="end_date"
											   min="{{\Carbon\Carbon::now()->toDateString()}}"
											   value="{{\Illuminate\Support\Carbon::parse($coupon->end_date)->format('Y-m-d')}}"
											   class="form-control"
											   autocomplete="off" required>
										<div class="text-danger">
											@error('end_date') @lang($message) @enderror
										</div>
									</div>
								</div>
							</div>
							<div class="row align-items-center">
								<div class="col-md-6">
									<div class="input-box form-group">
										<label for="Coupon Code">@lang('Discount Amount')</label>
										<div class="input-group">
											<div class="input-group-prepend">
												<span class="form-control">{{ basicControl()->currency_symbol }}</span>
											</div>
											<input type="number" step="0.001"
												   name="discount_amount"
												   value="{{ $coupon->discount_amount }}"
												   class="form-control"
												   placeholder="@lang('Discount Amount')"
												   autocomplete="off" required>
											<div class="input-group-append">
												<select name="discount_type"
														class="form-control form-control-sm">
													<option
														value="flat" {{$coupon->discount_type == 'flat' ? 'selected':''}}>@lang('Fixed')</option>
													<option
														value="percentage" {{$coupon->discount_type == 'percentage' ? 'selected':''}}>@lang('%')</option>
												</select>
											</div>
										</div>
										<div class="text-danger">
											@error('discount_amount') @lang($message) @enderror
										</div>
									</div>
								</div>
								<div class="col-md-6">
									<div class="input-box form-group">
										<label>@lang('Status')</label>
										<div class="selectgroup w-100">
											<label class="selectgroup-item">
												<input type="radio" name="status" value="0"
													   class="selectgroup-input" {{$coupon->status == 0 ? 'checked':''}}>
												<span class="selectgroup-button">@lang('OFF')</span>
											</label>
											<label class="selectgroup-item">
												<input type="radio" name="status" value="1"
													   class="selectgroup-input" {{$coupon->status == 1 ? 'checked':''}}>
												<span class="selectgroup-button">@lang('ON')</span>
											</label>
										</div>
									</div>
								</div>
							</div>
							<button type="submit" class="btn-custom mt-3">@lang('Save Changes')</button>
						</form>
					</div>
				</section>
			</div>
		</div>
	</div>
@endsection

@push('script')
	<script>
		'use strict';
		$(document).on("click", "#generate", function () {
			let random = (Math.random() + 1).toString(36).substring(6);
			$('.code').val(random);
		})
	</script>
@endpush

