@extends(template().'layouts.user')
@section('page_title',__('QR Bot'))

@section('content')
	<div class="container-fluid">
		@if(!empty($qrCodeMSg))
			<div class="main row">
				<div class="col-md-12">
					<div class="qr-card-box text-start">
						<h5><i class="fas fa-info-circle"></i> @lang(strip_tags($qrCodeMSg['description']->description))</h5>
					</div>
				</div>
			</div>
		@endif
		<div class="main row g-4">
			<div class="col-md-6 col-lg-4 col-xl-3">
				<div class="qr-card-box">
					<h4 class="mb-0">@lang('Telegram QR Bot')</h4>
					<div class="qr-box">
						<input
							type="hidden"
							id="qrUrl"
							value={{"https://t.me/".$store->telegram_username}}/>
						<div id="qrcode"></div>
					</div>
					<div class="ms35">
						<a href="" class="btn-custom" id="download-qr"
						   download="Telegram.png'">
							<i class="fas fa-download"></i> @lang('Download')
						</a>
					</div>
				</div>
			</div>
			<div class="col-md-6 col-lg-4 col-xl-3">
				<div class="qr-card-box">
					<h4 class="mb-0">@lang('Messenger QR Bot')</h4>
					<div class="qr-box">
						<input
							type="hidden"
							id="qrUrl2"
							value="{{"https://m.me/106969959084928".$store->messenger_id}}"/>
						<div id="qrcode2"></div>
					</div>
					<div class="ms35">
						<a href="" class="btn-custom" id="download-qr2"
						   download="Whatsapp.png">
							<i class="fas fa-download"></i> @lang('Download')
						</a>
					</div>
				</div>
			</div>
			<div class="col-md-6 col-lg-4 col-xl-3">
				<div class="qr-card-box">
					<h4 class="mb-0">@lang('Whatsapp QR Bot')</h4>
					<div class="qr-box">
						<input
							type="hidden"
							id="qrUrl3"
							value="{{"https://wa.me/".$store->whatsapp_business_account}}"/>
						<div id="qrcode3"></div>
					</div>
					<div class="ms35">
						<a href="" class="btn-custom" id="download-qr3"
						   download="Whatsapp.png">
							<i class="fas fa-download"></i> @lang('Download')
						</a>
					</div>
				</div>
			</div>
		</div>
	</div>
@endsection

@push('script')
	<script>
		'use strict';
		//Telegram
		var qr = QRCode.generatePNG(document.getElementById('qrUrl').value, {
			ecclevel: "M",
			format: "html",
			margin: 4,
			modulesize: 8
		});

		var img = document.createElement("img");
		img.src = qr;
		document.getElementById('qrcode').appendChild(img);

		//For download
		var download = document.getElementById('download-qr').href = qr;

		//Messenger
		var qr = QRCode.generatePNG(document.getElementById('qrUrl2').value, {
			ecclevel: "M",
			format: "html",
			margin: 4,
			modulesize: 8
		});

		var img = document.createElement("img");
		img.src = qr;
		document.getElementById('qrcode2').appendChild(img);

		//For download
		var download = document.getElementById('download-qr2').href = qr;

		//Whatsapp
		var qr = QRCode.generatePNG(document.getElementById('qrUrl3').value, {
			ecclevel: "M",
			format: "html",
			margin: 4,
			modulesize: 8
		});

		var img = document.createElement("img");
		img.src = qr;
		document.getElementById('qrcode3').appendChild(img);

		//For download
		var download = document.getElementById('download-qr3').href = qr;


	</script>
	@if ($errors->any())
		@php
			$collection = collect($errors->all());
			$errors = $collection->unique();
		@endphp
		<script>
			"use strict";
			@foreach ($errors as $error)
			Notiflix.Notify.failure("{{trans($error)}}");
			@endforeach
		</script>
	@endif
@endpush

