@extends(template().'layouts.user')
@section('page_title',__('Notify Templates'))

@section('content')
	<div class="container-fluid">
		<div class="main row">
			<div class="col-12">
				<div class="dashboard-heading">
					<h2 class="mb-0">@lang('Notification Permission')</h2>
				</div>
				<div class="identity-confirmation">
					<form role="form" method="POST" action="{{route('user.notification.permission.update')}}"
						  enctype="multipart/form-data">
						@csrf
						@method('put')
						<div class="row g-4">
								<table class="table table-striped" id="service-table">
									<thead>
									<tr>
                                        <th scope="col">@lang('Notification Name')</th>
                                        <th scope="col">@lang('Email')</th>
                                        <th scope="col">@lang('SMS')</th>
                                        <th scope="col">@lang('Push')</th>
                                        <th class="text-start" scope="col">@lang('In App')</th>
									</tr>
									</thead>
									<tbody>
									@forelse($allTemplates as $key => $item)
                                        <tr>
                                            <td class="text-start" data-label="Notification Name">
                                                {{$item->name}}
                                            </td>
                                            <td data-label="Email">
                                                <div class="form-check form-switch">
                                                    <input class="form-check-input" type="checkbox"
                                                           role="switch" name="email_key[]"
                                                           value="{{$item->template_key ?? ""}}"
                                                           {{ !$item->email ? 'disabled':'' }}
                                                           id="emailSwitch"
                                                        {{ in_array($item->template_key, optional($user->notifypermission)->template_email_key ?? []) ? 'checked' : '' }}
                                                    >
                                                </div>
                                            </td>
                                            <td data-label="SMS">
                                                <div class="form-check form-switch">
                                                    <input class="form-check-input" type="checkbox"
                                                           role="switch" name="sms_key[]"
                                                           value="{{$item->template_key ?? ""}}"
                                                           {{ !$item->sms ? 'disabled':'' }}
                                                           id="smsSwitch"
                                                        {{ in_array($item->template_key, optional($user->notifypermission)->template_sms_key ?? []) ? 'checked' : '' }}
                                                    >
                                                </div>
                                            </td>
                                            <td data-label="Push">
                                                <div class="form-check form-switch">
                                                    <input class="form-check-input" type="checkbox"
                                                           role="switch"
                                                           name="push_key[]"
                                                           value="{{ $item->template_key ?? "" }}"
                                                           {{ !$item->push ? 'disabled' : '' }}
                                                           id="pushSwitch"
                                                        {{ in_array($item->template_key, optional($user->notifypermission)->template_push_key ?? []) ? 'checked' : '' }}
                                                    >
                                                </div>
                                            </td>
                                            <td data-label="In App">
                                                <div class="form-check form-switch">
                                                    <input class="form-check-input" type="checkbox"
                                                           role="switch"
                                                           name="in_app_key[]"
                                                           value="{{$item->template_key ?? ""}}"
                                                           id="appSwitch"
                                                        {{!$item->in_app ? 'disabled':''}}
                                                        {{ in_array($item->template_key, optional($user->notifypermission)->template_in_app_key ?? []) ? 'checked' : '' }}
                                                    >
                                                </div>
                                            </td>
                                        </tr>
									@empty
									@endforelse
									</tbody>
								</table>
							<button type="submit" class="btn-custom">@lang('Save Changes')</button>
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
@endsection

