
@if(!empty($testimonial))
	<section class="testimonial-section">
		<div class="container">
			<div class="row justify-content-center">
				<div class="col-lg-4">
					<div class="header-text">
						<h5>@lang($testimonial['single']['heading'] ?? '')</h5>
						<h3>@lang($testimonial['single']['title'] ?? '')</h3>
					</div>
				</div>
                <div class="col-lg-8">
                    <div class="testimonial-wrapper">
                        <div class="testimonials owl-carousel">
                            @foreach($testimonial['multiple'] as $item)
                                <div class="review-box">
                                    <div class="text">
                                        <div class="rating">
                                            <span>
                                                @for($i = 1; $i <= 5; $i++)
                                                    <i class="fas fa-star {{ $i <= $item['review'] ? 'reviewIcon' : '' }}"></i>
                                                @endfor
                                            </span>
                                        </div>
                                        <p>
                                            {!! __($item['description']) !!}
                                        </p>
                                        <div class="user-box">
                                            <div class="img">
                                                <img
                                                    src="{{ getFile($item['media']->image->driver,$item['media']->image->path) }}" alt="image"/>
                                            </div>
                                            <div class="text">
                                                <h5>@lang($item['name'])</h5>
                                                <span
                                                    class="title">@lang($item['designation'] ?? '')</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
			</div>
		</div>
	</section>
@endif
