
@php
$contact = getSectionData('contact','single');
$social = getSectionData('social','multiple');
@endphp
<footer class="footer-section">
	<div class="overlay">
		<div class="container">
			<div class="row gy-5 gy-lg-0">
				<div class="col-lg-3 col-md-6 pe-lg-5">
					<div class="footer-box">
						<a class="navbar-brand" href="{{ url('/')}}"> <img
								src="{{ getFile(basicControl()->logo_driver, basicControl()->logo) }}" alt="{{ basicControl()->site_title }}"/></a>
						@if($contact)
							<p class="company-bio">
								@lang(strip_tags(optional($contact->description)->about_company))
							</p>
						@endif

						@if(!empty($social))
							<div class="social-links">
								@foreach($social as $item)
									<a href="{{ optional($item->description)->link }}">
										<i class="{{ optional($item->description)->fontawesome_icon_class }}"></i>
									</a>
								@endforeach
							</div>
						@endif
					</div>
				</div>

				<div class="col-lg-2 col-md-6">
					<div class="footer-box">
						<h4>@lang('Useful Link')</h4>
						<ul>
                            @if(getFooterMenuData('useful_link') != null)
                                @foreach(getFooterMenuData('useful_link') as $list)
                                    {!! $list !!}
                                @endforeach
                            @endif
						</ul>
					</div>
				</div>
				<div class="col-lg-2 col-md-6">
					<div class="footer-box">
						<h4>@lang('Support Link')</h4>
						<ul>
                            @if(getFooterMenuData('support_link') != null)
                                @foreach(getFooterMenuData('support_link') as $list)
                                    {!! $list !!}
                                @endforeach
                            @endif
						</ul>
					</div>
				</div>
				@if(!empty($contact))
					<div class="col-lg-3 col-md-6">
						<div class="footer-box">
							<h4>@lang('Contact Us')</h4>
							<ul>
								<li class="d-flex"><i class="fal fa-map-marker-alt"></i>
									<span>{{ optional($contact->description)->location }}</span></li>
								<li><i class="fal fa-envelope"></i>
									<span>{{ optional($contact->description)->email }}</span></li>
								<li><i class="fal fa-phone-alt"></i>
									<span>{{ optional($contact->description)->phone }}</span></li>
							</ul>
						</div>
					</div>
				@endif
				<div class="col-lg-2 col-md-6">
					<div class="footer-box">
						<h4>@lang('Subscribe Newsletter')</h4>
						<form action="{{ route('subscribe') }}" method="post">
							@csrf
							<div class="input-group">
								<input type="email" class="form-control" name="email" placeholder="@lang('enter email')" required/>
								<button type="submit" class="btn-custom"><i class="fal fa-paper-plane" aria-hidden="true"></i></button>
							</div>
							@error('email')
							<span class="text-danger">{{ $message }}</span>
							@enderror
						</form>
					</div>
				</div>
			</div>

			<div class="d-flex copyright justify-content-between">
				<div>
					<span> @lang('All rights reserved') © {{date('Y')}} @lang('by')<a
							href="{{url('/')}}">@lang(basicControl()->site_title)</a> </span>
				</div>
				<div>
					@forelse($languages as $item)
						<a href="{{ route('language',$item->short_name) }}" class="language text-secondary {{ session()->get('lang') == $item->short_name ? 'langActive' : '' }}">@lang($item->name)</a>
					@empty
					@endforelse
				</div>
			</div>
		</div>
	</div>
</footer>
