<!DOCTYPE html>
<html lang="en" @if(session()->get('rtl') == 1) dir="rtl" @endif>
    <head>
        <meta charset="UTF-8"/>
        <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
        <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
        <link href="{{ getFile(basicControl()->favicon_driver, basicControl()->favicon) }}" rel="icon">
        <title>@yield('page_title') | @lang(basicControl()->site_title)</title>

        <meta name="csrf-token" content="{{ csrf_token() }}">
        <link rel="stylesheet" href="{{ asset($themeTrue . 'css/bootstrap.min.css')}}"/>

        <link rel="stylesheet" href="{{ asset($themeTrue . 'css/all.min.css')}}"/>
        <link rel="stylesheet" href="{{ asset($themeTrue . 'css/fontawesome.min.css')}}"/>
        <link rel="stylesheet" href="{{ asset($themeTrue . 'css/animate.css')}}"/>
        <link rel="stylesheet" href="{{ asset($themeTrue . 'css/owl.carousel.min.css')}}"/>
        <link rel="stylesheet" href="{{ asset($themeTrue . 'css/owl.theme.default.min.css')}}"/>
        <link rel="stylesheet" href="{{ asset($themeTrue . 'css/style.css')}}"/>
        @stack('css-lib')
        @stack('style')
        @laravelPWA
    </head>

    <body>
        <div id="app">
            <div class="dashboard-wrapper">
                @include(template().'partials.user.sidebar')
                @include($theme.'partials.user.bottom_nav')

                <div id="content">
                    <div class="overlay">
                        @include(template().'partials.user.topbar')
                        @yield('content')
                    </div>
                </div>
            </div>
            @stack('load-modal')
            @include(template().'partials.pwa')
        </div>

        <script src="{{ asset($themeTrue . 'js/bootstrap.bundle.min.js')}}"></script>
        <script src="{{ asset($themeTrue . 'js/jquery.min.js')}}"></script>
        <script src="{{ asset($themeTrue . 'js/owl.carousel.min.js')}}"></script>
        <script src="{{ asset($themeTrue . 'js/qrjs2.min.js')}}"></script>
        <script src="{{ asset($themeTrue . 'js/socialSharing.js')}}"></script>
        <script src="{{ asset('assets/global/js/notiflix-aio-3.2.6.min.js') }}"></script>
        <script src="{{ asset($themeTrue . 'js/script.js')}}"></script>

        <script src="{{ asset('assets/global/js/pusher.min.js') }}"></script>
        <script src="{{ asset('assets/global/js/vue.min.js') }}"></script>
        <script src="{{ asset('assets/global/js/axios.min.js') }}"></script>

        @stack('js-lib')
        @stack('script')


        <script>
            $(document).ready(function () {
                $(document).ajaxStart(function () {
                    $('#wait').removeClass('d-none').show();
                });
                $(document).ajaxComplete(function () {
                    $('#wait').hide();
                });
            });
        </script>
        <script>
            'use strict';
            // for search
            $(document).on('input', '.global-search', function () {
                var search = $(this).val().toLowerCase();

                if (search.length == 0) {
                    $('.search-result').find('.content').html('');
                    $(this).siblings('.search-backdrop').addClass('d-none');
                    $(this).siblings('.search-result').addClass('d-none');
                    return false;
                }

                $('.search-result').find('.content').html('');
                $(this).siblings('.search-backdrop').removeClass('d-none');
                $(this).siblings('.search-result').removeClass('d-none');

                var match = $('.sidebar-menu li').filter(function (idx, element) {
                    if (!$(element).find('a').hasClass('has-dropdown') && !$(element).hasClass('menu-header'))
                        return $(element).text().trim().toLowerCase().indexOf(search) >= 0 ? element : null;
                }).sort();

                if (match.length == 0) {
                    $('.search-result').find('.content').append(`<div class="search-item"><a href="javascript:void(0)">@lang('No result found')</a></div>`);
                    return false;
                }

                match.each(function (index, element) {
                    var item_text = $(element).text().replace(/(\d+)/g, '').trim();
                    var item_url = $(element).find('a').attr('href');
                    if (item_url != '#') {
                        $('.search-result').find('.content').append(`<div class="search-item"><a href="${item_url}">${item_text}</a></div>`);
                    }
                });
            });
        </script>



        @if (session()->has('success'))
            <script>
                Notiflix.Notify.success("@lang(session('success'))");
            </script>
        @endif
        @if (session()->has('error'))
            <script>
                Notiflix.Notify.failure("@lang(session('error'))");
            </script>
        @endif
        @if (session()->has('warning'))
            <script>
                Notiflix.Notify.warning("@lang(session('warning'))");
            </script>
        @endif
    </body>
</html>





