<!DOCTYPE html>
<html lang="en" @if(session()->get('rtl') == 1) dir="rtl" @endif />
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
	<link href="{{ getFile(config('basic.default_file_driver'),config('basic.favicon_image')) }}" rel="icon">
	<title> @yield('page_title') | {{basicControl()->site_title}} </title>

    <link rel="stylesheet" href="{{ asset($themeTrue . 'css/bootstrap.min.css')}}"/>
    <link rel="stylesheet" href="{{ asset($themeTrue . 'css/all.min.css')}}"/>
    <link rel="stylesheet" href="{{ asset($themeTrue . 'css/fontawesome.min.css')}}"/>
    <link rel="stylesheet" href="{{ asset($themeTrue . 'css/animate.css')}}"/>
    <link rel="stylesheet" href="{{ asset($themeTrue . 'css/owl.carousel.min.css')}}"/>
    <link rel="stylesheet" href="{{ asset($themeTrue . 'css/owl.theme.default.min.css')}}"/>
    @stack('css-lib')
    @stack('style')
    <link rel="stylesheet" href="{{ asset($themeTrue . 'css/style.css')}}"/>

</head>

<body class="">
@if(request()->routeIs('public.view'))
	@if(isset($link))
		<div id="draggable" class="no-select is-open">
			@if(isShopOpen($link) == 'open')
				<h4>@lang('Open Now')</h4>
			@else
				<h4>@lang('closed Now')</h4>
			@endif
		</div>
	@endif
@endif

@yield('content')


<script src="{{ asset($themeTrue . 'js/bootstrap.bundle.min.js')}}"></script>
<script src="{{ asset($themeTrue . 'js/jquery.min.js')}}"></script>
<script src="{{ asset($themeTrue . 'js/owl.carousel.min.js')}}"></script>
<script src="{{ asset($themeTrue . 'js/qrjs2.min.js')}}"></script>
<script src="{{ asset($themeTrue . 'js/socialSharing.js')}}"></script>
<script src="{{ asset('assets/global/js/notiflix-aio-3.2.6.min.js') }}"></script>
<script src="{{ asset($themeTrue . 'js/script.js')}}"></script>
<script src="{{asset('assets/global/js/pusher.min.js')}}"></script>
<script src="{{asset('assets/global/js/vue.min.js')}}"></script>
<script src="{{asset('assets/global/js/axios.min.js')}}"></script>
{{--<script src="{{ asset('assets/dashboard/js/scripts.js') }}"></script>--}}

@stack('scripts')
@stack('extra_scripts')

<script>
	// horizontal scroll
	const element = document.querySelector("#categories");
	element.addEventListener("wheel", (event) => {
		event.preventDefault();
		element.scrollBy({
			left: event.deltaY < 0 ? -30 : 30,
		});
	});

    $(document).ready(function () {
        $(document).ajaxStart(function () {
            $('#wait').removeClass('d-none').show();
        });
        $(document).ajaxComplete(function () {
            $('#wait').hide();
        });
    });
</script>

<script>
    'use strict';
    // for search
    $(document).on('input', '.global-search', function () {
        var search = $(this).val().toLowerCase();

        if (search.length == 0) {
            $('.search-result').find('.content').html('');
            $(this).siblings('.search-backdrop').addClass('d-none');
            $(this).siblings('.search-result').addClass('d-none');
            return false;
        }

        $('.search-result').find('.content').html('');
        $(this).siblings('.search-backdrop').removeClass('d-none');
        $(this).siblings('.search-result').removeClass('d-none');

        var match = $('.sidebar-menu li').filter(function (idx, element) {
            if (!$(element).find('a').hasClass('has-dropdown') && !$(element).hasClass('menu-header'))
                return $(element).text().trim().toLowerCase().indexOf(search) >= 0 ? element : null;
        }).sort();

        if (match.length == 0) {
            $('.search-result').find('.content').append(`<div class="search-item"><a href="javascript:void(0)">@lang('No result found')</a></div>`);
            return false;
        }

        match.each(function (index, element) {
            var item_text = $(element).text().replace(/(\d+)/g, '').trim();
            var item_url = $(element).find('a').attr('href');
            if (item_url != '#') {
                $('.search-result').find('.content').append(`<div class="search-item"><a href="${item_url}">${item_text}</a></div>`);
            }
        });
    });


    var isMouseDown,
        initX,
        initY,
        height = (draggable)? draggable.offsetHeight:0,
        width = (draggable)?  draggable.offsetWidth:0;

    draggable.addEventListener("mousedown", function (e) {
        isMouseDown = true;
        document.body.classList.add("no-select");
        initX = e.offsetX;
        initY = e.offsetY;
    });

    document.addEventListener("mousemove", function (e) {
        if (isMouseDown) {
            var cx = e.clientX - initX,
                cy = e.clientY - initY;
            if (cx < 0) {
                cx = 0;
            }
            if (cy < 0) {
                cy = 0;
            }
            if (window.innerWidth - e.clientX + initX < width) {
                cx = window.innerWidth - width;
            }
            if (e.clientY > window.innerHeight - height + initY) {
                cy = window.innerHeight - height;
            }
            draggable.style.left = cx + "px";
            draggable.style.top = cy + "px";
        }
    });

    draggable.addEventListener("mouseup", function () {
        isMouseDown = false;
        document.body.classList.remove("no-select");
    });

</script>

@if(session()->has('success'))
    <script>
        Notiflix.Notify.success("{{ __(session()->get('success')) }}");
    </script>
@endif
@if(session()->has('alert'))
    <script>
        Notiflix.Notify.failure("{{ __(session()->get('alert')) }}");
    </script>
@endif
@if(session()->has('warning'))
    <script>
        Notiflix.Notify.warning("{{ __(session()->get('warning')) }}");
    </script>
@endif
@if(session()->has('error'))
    <script>
        Notiflix.Notify.failure("{{ __(session()->get('error')) }}");
    </script>
@endif
</body>
</html>
