@extends(template().'layouts.app')
@section('content')
    <section id="login" class="login-section">
        <div class="container">
            <div class="row d-flex justify-content-center">
                <div class="col-lg-6">
                    <form action="{{ route('user.mail.verify') }}" method="post">
                        @csrf
                        <div class="row gy-3">
                            <div class="col-12">
                                <h4>@lang('Verify Your Email')</h4>
                                <p class="d-flex flex-wrap">@lang("Your Email Address is") {!! maskEmail(auth()->user()->email) !!}</p>
                            </div>
                            <div class="input-box col-12">
                                <input type="text" class="form-control @error('code') is-invalid @enderror" name="code" placeholder="@lang('Verification Code')">
                                @error('code')
                                <span class="invalid-feedback d-block" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                                @error('error')
                                <span class="invalid-feedback d-block" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>

                            <button type="submit" class="btn-custom w-100">@lang('Submit')</button>
                            <div class="bottom mt-2">
                                @lang('Didn\'t get Code? Click to')
                                <a href="{{route('user.resend.code')}}?type=email">@lang('Resend code')</a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </section>
@endsection
