@extends('admin.layouts.app')
@section('page_title', __('Plan Create'))
@section('content')
    <div class="content container-fluid">
        <div class="page-header">
            <div class="row align-items-end">
                <div class="col-sm mb-2 mb-sm-0">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb breadcrumb-no-gutter">
                            <li class="breadcrumb-item"><a class="breadcrumb-link"
                                                           href="javascript:void(0);">@lang('Dashboard')</a></li>
                            <li class="breadcrumb-item" aria-current="page">@lang('Manage Plan')</li>
                            <li class="breadcrumb-item" aria-current="page">@lang('Plans')</li>
                            <li class="breadcrumb-item active" aria-current="page">@lang('Create')</li>
                        </ol>
                    </nav>
                    <h1 class="page-header-title">@lang('Create From')</h1>
                </div>
            </div>
        </div>

        <div class="card">
            <div class="card-body">
                <ul class="nav nav-tabs" id="myTab" role="tablist">
                    @foreach($languages as $key => $language)
                        <li class="nav-item">
                            <a class="nav-link {{ $loop->first ? 'active' : '' }}" data-bs-toggle="tab"
                               href="#lang-tab-{{ $key }}" role="tab" aria-controls="lang-tab-{{ $key }}"
                               aria-selected="{{ $loop->first ? 'true' : 'false' }}">@lang($language->name)</a>
                        </li>
                    @endforeach
                </ul>

                <div class="tab-content mt-2" id="myTabContent">
                    @foreach($languages as $key => $language)
                        <div class="tab-pane fade {{ $loop->first ? 'show active' : '' }}" id="lang-tab-{{ $key }}"
                             role="tabpanel">
                            <form method="post" action="{{ route('admin.plan.store', $language->id) }}" class="mt-4"
                                  enctype="multipart/form-data">
                                @csrf
                                <div class="row g-3 d-flex">
                                    <div class="{{ $loop->index == 0 ? 'col-lg-4' : 'col-lg-6' }}">
                                        <label for="nameLabel" class="form-label">@lang('Plan Name')</label>
                                        <input type="text"
                                               class="form-control @error('plan_name'.'.'.$language->id) is-invalid @enderror"
                                               name="plan_name[{{ $language->id }}]" id="nameLabel"
                                               placeholder="@lang('Enter Name')" aria-label="Name"
                                               autocomplete="off"
                                               value="{{ old('plan_name'.'.'.$language->id) }}">
                                        @error('plan_name'.'.'.$language->id)
                                        <span class="invalid-feedback">{{ $message }}</span>
                                        @enderror
                                    </div>

                                    <div class="{{ $loop->index == 0 ? 'col-lg-4' : 'col-lg-6' }}">
                                        <label for="badgeLabel" class="form-label">@lang('Badge Name')</label>
                                        <input type="text"
                                               class="form-control @error('badge_name'.'.'.$language->id) is-invalid @enderror"
                                               name="badge_name[{{ $language->id }}]" id="badgeLabel"
                                               placeholder="@lang('Enter Name')" aria-label="Badge"
                                               autocomplete="off"
                                               value="{{ old('badge_name'.'.'.$language->id) }}">
                                        @error('badge_name'.'.'.$language->id)
                                        <span class="invalid-feedback">{{ $message }}</span>
                                        @enderror
                                    </div>

                                    @if ($loop->index == 0)
                                        <div class="col-lg-4">
                                            <label for="storeLabel" class="form-label">@lang('Number Of Stores')</label>
                                            <input type="number"
                                                   class="form-control @error('num_stores') is-invalid @enderror"
                                                   name="num_stores" id="storeLabel"
                                                   placeholder="@lang('Enter Store Number')"
                                                   aria-label="Number Of Stores"
                                                   autocomplete="off"
                                                   value="{{ old('num_stores') }}">
                                            @error('num_stores')
                                            <span class="invalid-feedback">{{ $message }}</span>
                                            @enderror
                                        </div>
                                        <div class="col-lg-4">
                                            <label for="menuLabel" class="form-label">@lang('Quantity Of Menu')</label>
                                            <input type="number"
                                                   class="form-control @error('product_qty') is-invalid @enderror"
                                                   name="product_qty" id="menuLabel"
                                                   placeholder="@lang('Enter Menu Quantity')"
                                                   aria-label="Quantity Of Menu"
                                                   autocomplete="off"
                                                   value="{{ old('product_qty') }}">
                                            @error('product_qty')
                                            <span class="invalid-feedback">{{ $message }}</span>
                                            @enderror
                                        </div>
                                        <div class="col-lg-4">
                                            <label for="orderLabel" class="form-label">@lang('Number Of Orders')</label>
                                            <input type="number"
                                                   class="form-control @error('order_num') is-invalid @enderror"
                                                   name="order_num" id="orderLabel"
                                                   placeholder="@lang('Enter Order Number')"
                                                   aria-label="Number Of Orders"
                                                   autocomplete="off"
                                                   value="{{ old('order_num') }}">
                                            @error('order_num')
                                            <span class="invalid-feedback">{{ $message }}</span>
                                            @enderror
                                        </div>
                                        <div class="form-group col-lg-4">
                                            <label class="form-label">@lang('Status')</label>
                                            <div class="list-group-item">
                                                <div class="d-flex">
                                                    <div class="flex-grow-1">
                                                        <div class="row align-items-center">
                                                            <div class="col">
                                                                <span class="d-block fs-6 text-body">
                                                                    @lang('You can either switch to active mode or inactive mode, depending on your preference or the situation')
                                                                </span>
                                                            </div>
                                                            <div class="col-auto">
                                                                <label class="row form-check form-switch mb-3"
                                                                       for="is_video">
                                                                    <span class="col-4 col-sm-3 text-end">
                                                                        <input type='hidden' value='0' name='status'>
                                                                        <input
                                                                            class="form-check-input @error('status') is-invalid @enderror"
                                                                            type="checkbox" name="status" id="status"
                                                                            value="1" {{ old('status') == 1 ? 'checked' : '' }}>
                                                                    </span>
                                                                    @error('is_video')
                                                                    <span
                                                                        class="invalid-feedback d-block">{{ $message }}</span>
                                                                    @enderror
                                                                </label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="form-group col-lg-4">
                                            <label class="form-label">@lang('Telegram Bot')</label>
                                            <div class="list-group-item">
                                                <div class="d-flex">
                                                    <div class="flex-grow-1">
                                                        <div class="row align-items-center">
                                                            <div class="col">
                                                                <span class="d-block fs-6 text-body">
                                                                    @lang('You can either switch to active mode or inactive mode, depending on your preference or the situation')
                                                                </span>
                                                            </div>
                                                            <div class="col-auto">
                                                                <label class="row form-check form-switch mb-3"
                                                                       for="telegram_bot">
                                                                    <span class="col-4 col-sm-3 text-end">
                                                                        <input type='hidden' value='0'
                                                                               name='telegram_bot'>
                                                                        <input
                                                                            class="form-check-input @error('telegram_bot') is-invalid @enderror"
                                                                            type="checkbox" name="telegram_bot"
                                                                            id="telegram_bot" value="1" {{ old('telegram_bot') == 1 ? 'checked' : '' }}>
                                                                    </span>
                                                                    @error('telegram_bot')
                                                                    <span
                                                                        class="invalid-feedback d-block">{{ $message }}</span>
                                                                    @enderror
                                                                </label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group col-lg-4">
                                            <label class="form-label">@lang('Messenger Bot')</label>
                                            <div class="list-group-item">
                                                <div class="d-flex">
                                                    <div class="flex-grow-1">
                                                        <div class="row align-items-center">
                                                            <div class="col">
                                                                <span class="d-block fs-6 text-body">
                                                                    @lang('You can either switch to active mode or inactive mode, depending on your preference or the situation')
                                                                </span>
                                                            </div>
                                                            <div class="col-auto">
                                                                <label class="row form-check form-switch mb-3"
                                                                       for="telegram_bot">
                                                                    <span class="col-4 col-sm-3 text-end">
                                                                        <input type='hidden' value='0'
                                                                               name='messenger_bot'>
                                                                        <input
                                                                            class="form-check-input @error('messenger_bot') is-invalid @enderror"
                                                                            type="checkbox" name="messenger_bot"
                                                                            id="messenger_bot" value="1" {{ old('messenger_bot') == 1 ? 'checked' : '' }}>
                                                                    </span>
                                                                    @error('messenger_bot')
                                                                    <span
                                                                        class="invalid-feedback d-block">{{ $message }}</span>
                                                                    @enderror
                                                                </label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group col-lg-4">
                                            <label class="form-label">@lang('Whatsapp Bot')</label>
                                            <div class="list-group-item">
                                                <div class="d-flex">
                                                    <div class="flex-grow-1">
                                                        <div class="row align-items-center">
                                                            <div class="col">
                                                                <span class="d-block fs-6 text-body">
                                                                    @lang('You can either switch to active mode or inactive mode, depending on your preference or the situation')
                                                                </span>
                                                            </div>
                                                            <div class="col-auto">
                                                                <label class="row form-check form-switch mb-3"
                                                                       for="telegram_bot">
                                                                    <span class="col-4 col-sm-3 text-end">
                                                                        <input type='hidden' value='0'
                                                                               name='whatsapp_bot'>
                                                                        <input
                                                                            class="form-check-input @error('whatsapp_bot') is-invalid @enderror"
                                                                            type="checkbox" name="whatsapp_bot"
                                                                            id="whatsapp_bot" value="1" {{ old('whatsapp_bot') == 1 ? 'checked' : '' }}>
                                                                    </span>
                                                                    @error('whatsapp_bot')
                                                                    <span
                                                                        class="invalid-feedback d-block">{{ $message }}</span>
                                                                    @enderror
                                                                </label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="fieldDataWrapper">
                                            <div class="form-group divider-end">
                                                <a href="javascript:void(0)" data-language="1"
                                                   class="btn btn-primary float-left addFieldData">
                                                    <i class="fa fa-plus-circle"></i> @lang('Add Price')</a>
                                            </div>
                                            <div class="col-md-12 my-2">
                                                <div class="input-group align-items-center">
                                                    <span class="form-control">@lang('Price')</span>
                                                    <input class="form-control" type="number" name="price[]"
                                                           value="{{ old('price.0') }}" placeholder="@lang('0')"
                                                           required>
                                                    <div class="input-group-append">
                                                        <span
                                                            class="form-control">{{ basicControl()->base_currency }}</span>
                                                    </div>
                                                    <div class="input-group-prepend col-md-6 ms-2">
                                                        <select class="form-control schedule" name="schedule[]"
                                                                required>
                                                            <option value="" disabled
                                                                    selected>@lang('Select Schedule')</option>
                                                            @foreach($schedules as $item)
                                                                <option
                                                                    value="{{ $item->id }}" {{ old('schedule.0') == $item->id ? 'selected' : '' }}>
                                                                    {{ optional($item->details)->name }}
                                                                    ({{ $item->days }} @lang( $item->days > 1 ? 'Days' : 'Day')
                                                                    )
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="fieldDataHtml d-none">
                                            <div class="row d-flex align-items-center">
                                                <div class="form-group col-md-12">
                                                    <div class="input-group align-items-center">
                                                        <span class="form-control">@lang('Price')</span>
                                                        <input class="form-control" type="number" name="price[]"
                                                               placeholder="@lang('0')">
                                                        <div class="input-group-append">
                                                            <span
                                                                class="form-control">{{ basicControl()->base_currency }}</span>
                                                        </div>
                                                        <div class="input-group-prepend col-md-6 ms-2">
                                                            <select class="form-control schedule" name="schedule[]">
                                                                <option value="" disabled
                                                                        selected>@lang('Select Schedule')</option>
                                                                @foreach($schedules as $item)
                                                                    <option value="{{ $item->id }}">
                                                                        {{ optional($item->details)->name }}
                                                                        ({{ $item->days }} @lang( $item->days > 1 ? 'Days' : 'Day')
                                                                        )
                                                                    </option>
                                                                @endforeach
                                                            </select>
                                                        </div>
                                                        <a href="javascript:void(0);"
                                                           class="btn btn-outline-danger removeDiv"><i
                                                                class="fas fa-times"></i></a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @endif

                                    <div class="col-lg-12 bg-white mb-3">
                                        <label class="form-label">@lang('Note')</label>
                                        <textarea class="form-control"
                                                  name="note[{{ $language->id }}]" id="note" rows="3"
                                                  placeholder="@lang('note')">{{ old('note'.'.'.$language->id) }}</textarea>
                                        <div class="invalid-feedback d-block">
                                            @error('note'.'.'.$language->id) @lang($message) @enderror
                                        </div>
                                    </div>
                                </div>
                                <button type="submit"
                                        class="btn waves-effect waves-light btn-rounded btn-primary btn-block mt-3 w-100">@lang('Save changes')</button>
                            </form>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
@endsection

@push('script')
    <script>
        'use strict'
        var countSchedule = "{{count($schedules)}}"
        var count = 1;
        $(document).on('click', '.addFieldData', function (e) {
            if ((parseInt(countSchedule)) > count) {
                e.preventDefault();
                let fieldDataHtml = $('.fieldDataHtml').html();
                $('.fieldDataWrapper').append(fieldDataHtml);
                count++
            } else {
                Notiflix.Notify.failure('You can\'t add more than ' + countSchedule);
            }
        });

        $(document).on('click', '.removeDiv', function (e) {
            e.preventDefault();
            $(this).closest('.row').remove();
            count--
        });
    </script>
@endpush





