<?php

namespace Database\Seeders;

use App\Models\Page;
use Carbon\Carbon;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class PageSeeder extends Seeder
{
    public function run(): void
    {
        $pages = [
//            ['name' => 'Blog Details', 'slug' => 'blog-details', 'template_name' => 'light', 'type' => 1],
//            ['name' => 'login', 'slug' => 'login', 'template_name' => 'light', 'type' => 1],
//            ['name' => 'register', 'slug' => 'register', 'template_name' => 'light', 'type' => 1],
//            ['name' => 'sms verification', 'slug' => 'sms-verification', 'template_name' => 'light', 'type' => 1],
//            ['name' => 'email verification', 'slug' => 'email-verification', 'template_name' => 'light', 'type' => 1],
//            ['name' => '2FA verification', 'slug' => '2FA-verification', 'template_name' => 'light', 'type' => 1],
//            ['name' => 'Reset Password', 'slug' => 'reset-password', 'template_name' => 'light', 'type' => 1],
//            ['name' => 'Cookie Policy', 'slug' => 'cookie-policy', 'template_name' => 'light', 'type' => 1],
//            ['name' => 'Purchase Plan', 'slug' => 'purchase-plan', 'template_name' => 'light', 'type' => 1],
        ];

        foreach ($pages as $page) {
            Page::updateOrCreate(
                ['name' => $page['name']],
                [
                    'slug' => $page['slug'],
                    'template_name' => $page['template_name'],
                    'type' => $page['type'],
                ],
                [
                    'created_at' => \Illuminate\Support\Carbon::now(),
                    'updated_at' => Carbon::now(),
                ]
            );
        }

    }
}
