<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('basic_controls', function (Blueprint $table) {
            $table->string('cookie_title')->after('date_time_format')->nullable();
            $table->text('cookie_sub_title')->after('cookie_title')->nullable();
            $table->text('cookie_description')->after('cookie_sub_title')->nullable();
            $table->string('cookie_image')->after('cookie_description')->nullable();
            $table->string('cookie_image_driver')->after('cookie_image')->nullable();
            $table->tinyInteger('cookie_status')->after('cookie_image_driver')->default(1);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('basic_controls', function (Blueprint $table) {
            $table->dropColumn(['cookie_title','cookie_sub_title','cookie_description','cookie_image','cookie_image_driver','cookie_status']);
        });
    }
};
