<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('store_products', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->index()->nullable();
            $table->foreignId('category_id')->index()->nullable();
            $table->string('name')->nullable();
            $table->double('price')->nullable();
            $table->string('sku')->nullable();
            $table->string('tag')->nullable();
            $table->text('extra_products')->nullable();
            $table->text('variants')->nullable();
            $table->longText('description')->nullable();
            $table->text('image')->nullable();
            $table->string('driver')->nullable();
            $table->tinyInteger('status')->default(1)->comment('0=>inactive , 1=>active');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('store_products');
    }
};
