<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('stores', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->nullable()->index();
            $table->string('name')->nullable();
            $table->tinyInteger('shipping_charge')->default(1)->comment('0 : Inactive, 1 : Active');
            $table->string('delivery_note')->default('Disabled');
            $table->tinyInteger('cash_on_delivery')->default(1)->comment('0 : Off, 1 : On');
            $table->text('link')->nullable();
            $table->mediumText('short_description')->nullable();
            $table->longText('bot_command')->nullable();
            $table->string('telegram_id')->nullable();
            $table->string('telegram_token')->nullable();
            $table->string('telegram_first_name')->nullable();
            $table->string('telegram_username')->nullable();
            $table->text('telegram_initiate_message')->nullable();
            $table->string('telegram_bot_image')->nullable();
            $table->string('telegram_bot_image_driver')->nullable();
            $table->string('messenger_id')->nullable();
            $table->text('messenger_token')->nullable();
            $table->string('messenger_bot_image')->nullable();
            $table->string('messenger_bot_image_driver')->nullable();
            $table->text('messenger_initiate_message')->nullable();
            $table->string('whatsapp_sid')->nullable();
            $table->string('whatsapp_token')->nullable();
            $table->string('whatsapp_business_account')->nullable();
            $table->text('whatsapp_initiate_message')->nullable();
            $table->string('whatsapp_bot_image')->nullable();
            $table->string('whatsapp_bot_image_driver')->nullable();
            $table->tinyInteger('status')->default(1)->comment('0 : Off, 1 : On');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('stores');
    }
};
