<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('plan_schedules', function (Blueprint $table) {
            $table->id();
            $table->foreignId('plan_id')->index()->nullable();
            $table->foreignId('schedule_id')->index()->nullable();
            $table->double('price')->default(0.00);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('plan_schedules');
    }
};
