<?php
return [
    'light' => [
        'hero' => [
            'single' => [
                'field_name' => [
                    'heading' => 'text',
                    'title' => 'text',
                    'sub_title' => 'text',
                    'description' => 'textarea',
                    'button_name' => 'text',
                    'button_link' => 'text',
                    'image'=>'file',
                ],
                'validation' => [
                    'heading.*' => 'required|string|max:200',
                    'title.*' => 'required|string|max:100',
                    'sub_title.*' => 'required|string|max:200',
                    'description.*' => 'required|string|max:500',
                    'button_name.*' => 'required|string|max:100',
                    'button_link.*' => 'nullable|string',
                    'image.*' => 'required|image|mimes:jpg,jpeg,png',
                ],
                'size'=>[
                    'image' => '710x550',
                ],
            ],
            'contentPreview' => [
                'Hero'=>config('content_preview_path.theme_one').'/hero.png',
            ],
        ],

        'about' => [
            'single' => [
                'field_name' => [
                    'heading' => 'text',
                    'title' => 'text',
                    'description' => 'textarea',
                    'button_name' => 'text',
                    'button_link' => 'text',
                    'image'=>'file',
                ],
                'validation' => [
                    'heading.*' => 'required|string|max:200',
                    'title.*' => 'required|string|max:100',
                    'description.*' => 'required|string|max:500',
                    'button_name.*' => 'required|string|max:100',
                    'button_link.*' => 'nullable|string',
                    'image.*' => 'required|image|mimes:jpg,jpeg,png',
                ],
                'size'=>[
                    'image' => '1620x1080',
                ],
            ],
            'contentPreview' => [
                'About'=>config('content_preview_path.theme_one').'/about.png',
            ],
        ],

        'feature' => [
            'single' => [
                'field_name' => [
                    'heading' => 'text',
                ],
                'validation' => [
                    'heading.*' => 'required|string|max:200'
                ]
            ],
            'multiple' => [
                'field_name' => [
                    'order_by' => 'text',
                    'title' => 'text',
                    'description' => 'textarea',
                    'image'=>'file',
                ],
                'validation' => [
                    'order_by.*' => 'required|numeric',
                    'title.*' => 'required|string|max:100',
                    'description.*' => 'required|string|max:500',
                    'image.*' => 'required|image|mimes:jpg,jpeg,png',
                ],
                'size'=>[
                    'image' => '64x64',
                ],
            ],
            'contentPreview' => [
                'Feature'=>config('content_preview_path.theme_one').'/feature.png',
            ],
        ],

        'how_it_work' => [
            'single' => [
                'field_name' => [
                    'heading' => 'text',
                    'title' => 'text',
                    'sub_title' => 'text',
                    'video' => 'video',
                ],
                'validation' => [
                    'heading.*' => 'required|string|max:200',
                    'title.*' => 'required|string|max:200',
                    'sub_title.*' => 'required|string|max:200',
                    'video.*' => 'required|max:5000'
                ]
            ],
            'multiple' => [
                'field_name' => [
                    'title' => 'text',
                    'description' => 'textarea'
                ],
                'validation' => [
                    'title.*' => 'required|string|max:100',
                    'description.*' => 'required|string|max:500',
                ],
            ],
            'contentPreview' => [
                'How It Work'=>config('content_preview_path.theme_one').'/how-it-work.png',
            ],
        ],

        'plan' => [
            'single' => [
                'field_name' => [
                    'heading' => 'text',
                    'title' => 'text',
                    'sub_title' => 'text',
                ],
                'validation' => [
                    'heading.*' => 'required|string|max:100',
                    'title.*' => 'required|string|max:200',
                    'sub_title.*' => 'required|string|max:400'
                ]
            ],
            'contentPreview' => [
                'Plan'=>config('content_preview_path.theme_one').'/plan.png',
            ],
        ],

        'testimonial' => [
            'single' => [
                'field_name' => [
                    'heading' => 'text',
                    'title' => 'text',
                ],
                'validation' => [
                    'heading.*' => 'required|string|max:100',
                    'title.*' => 'required|string|max:200'
                ]
            ],
            'multiple' => [
                'field_name' => [
                    'name' => 'text',
                    'designation' => 'text',
                    'review' => 'text',
                    'description' => 'textarea',
                    'image'=>'file',
                ],
                'validation' => [
                    'name.*' => 'required|string|max:100',
                    'designation.*' => 'required|string|max:100',
                    'review.*' => 'required|integer|between:1,5',
                    'description.*' => 'required|string|max:500',
                    'image.*' => 'required|image|mimes:jpg,jpeg,png',
                ],
                'size'=>[
                    'image' => '200x200',
                ],
            ],
            'contentPreview' => [
                'Testimonial'=>config('content_preview_path.theme_one').'/testimonial.png',
            ],
        ],

        'blog' => [
            'single' => [
                'field_name' => [
                    'heading' => 'text',
                    'title' => 'text',
                ],
                'validation' => [
                    'heading.*' => 'required|string|max:100',
                    'title.*' => 'required|string|max:200',
                ]
            ],
            'contentPreview' => [
                'Blog'=>config('content_preview_path.theme_one').'/blog.png',
            ],
        ],

        'process' => [
            'single' => [
                'field_name' => [
                    'heading' => 'text',
                    'title' => 'text',
                    'description' => 'textarea',
                    'image'=>'file',
                ],
                'validation' => [
                    'heading.*' => 'required|string|max:100',
                    'title.*' => 'required|string|max:200',
                    'description.*' => 'required|string|max:500',
                    'image.*' => 'required|image|mimes:jpg,jpeg,png',
                ],
                'size'=>[
                    'image' => '1600x1100',
                ],
            ],
            'contentPreview' => [
                'Process'=>config('content_preview_path.theme_one').'/process.png',
            ],
        ],

        'faq' => [
            'multiple' => [
                'field_name' => [
                    'title' => 'text',
                    'description' => 'textarea',
                ],
                'validation' => [
                    'title.*' => 'required|string|max:200',
                    'description.*' => 'required|string|max:1500',
                ],
            ],
            'contentPreview' => [
                'FAQ'=>config('content_preview_path.theme_one').'/faq.png',
            ],
        ],

        'terms_and_conditions' => [
            'single' => [
                'field_name' => [
                    'description' => 'textarea',
                ],
                'validation' => [
                    'description.*' => 'required|string|max:7000',
                ],
            ],
            'contentPreview' => [
                'Terms and Conditions'=>config('content_preview_path.theme_one').'/terms_and_conditions.png',
            ],
        ],

        'privacy_policy' => [
            'single' => [
                'field_name' => [
                    'description' => 'textarea',
                ],
                'validation' => [
                    'title.*' => 'required|string|max:200',
                    'description.*' => 'required|string|max:7000',
                ],
            ],
            'contentPreview' => [
                'Privacy Policy'=>config('content_preview_path.theme_one').'/privacy_policy.png',
            ],
        ],

        'contact' => [
            'single' => [
                'field_name' => [
                    'title' => 'text',
                    'sub_title' => 'text',
                    'location' => 'text',
                    'email' => 'text',
                    'phone' => 'text',
                    'about_company' => 'textarea',
                ],
                'validation' => [
                    'title.*' => 'required|string|max:100',
                    'sub_title.*' => 'required|string|max:200',
                    'location.*' => 'required|string|max:1000',
                    'email.*' => 'required|string|max:50',
                    'phone.*' => 'required|string|max:20',
                    'about_company.*' => 'required|string|max:500',
                ],
            ],
            'contentPreview' => [
                'Contact'=>config('content_preview_path.theme_one').'/contact.png',
            ],
        ],

        'social' => [
            'multiple' => [
                'field_name' => [
                    'fontawesome_icon_class' => 'text',
                    'link' => 'text',
                ],
                'validation' => [
                    'fontawesome_icon_class.*' => 'required|string|max:100',
                    'link.*' => 'required|string|max:1000',
                ],
            ],
            'contentPreview' => [
                'Social'=>config('content_preview_path.theme_one').'/social.png',
            ],
        ],

        'qr_code_hint' => [
            'single' => [
                'field_name' => [
                    'description' => 'textarea',
                ],
                'validation' => [
                    'description.*' => 'required|string|max:500',
                ],
            ],
            'contentPreview' => [
                'QR Code Hint'=>config('content_preview_path.theme_one').'/qr_code_hint.png',
            ],
        ],

        'pwa_popup' => [
            'single' => [
                'field_name' => [
                    'title' => 'text',
                    'short_description' => 'text',
                    'description' => 'text',
                    'image' => 'file'
                ],
                'validation' => [
                    'title' => 'nullable',
                    'short_description.*' => 'nullable',
                    'description' => 'nullable',
                    'image.*' => 'nullable|max:3072|image|mimes:jpg,jpeg,png',
                ],
                'size' => [
                    'image' => '48x48',
                ]
            ],
            'multiple' => [
                'field_name' => [
                    'image' => 'file'
                ],
                'validation' => [
                    'image.*' => 'required|max:3072|image|mimes:jpg,jpeg,png',
                ]
            ],
            'contentPreview' => [
                'PWA Popup' => config('content_preview_path.theme_one') . '/pwa.png',
            ],
        ],





    ],

    'message' => [
        'required' => 'This field is required.',
        'min' => 'This field must be at least :min characters.',
        'max' => 'This field may not be greater than :max characters.',
        'image' => 'This field must be image.',
        'mimes' => 'This image must be a file of type: jpg, jpeg, png.',
        'integer' => 'This field must be an integer value',
    ],

    'content_media' => [
        'image' => 'file',
        'thumb_image' => 'file',
        'my_link' => 'url',
        'icon' => 'icon',
        'count_number' => 'number',
        'start_date' => 'date',
        'video' => 'video',
    ]
];

