// add bg to nav
window.addEventListener("scroll", function () {
	let scrollpos = window.scrollY;
	const header = document.querySelector("nav");
	const headerHeight = header.offsetHeight;
	if (scrollpos >= headerHeight) {
		header.classList.add("active");
	} else {
		header.classList.remove("active");
	}
});

// active nav item
const navItem = document.getElementsByClassName("nav-link");
for (const element of navItem) {
	element.addEventListener("click", () => {
		for (const ele of navItem) {
			ele.classList.remove("active");
		}
		element.classList.add("active");
	});
}

// tab
const tabs = document.getElementsByClassName("tab");
const contents = document.getElementsByClassName("content");
for (const element of tabs) {
	const tabId = element.getAttribute("tab-id");
	const content = document.getElementById(tabId);
	element.addEventListener("click", () => {
		for (const t of tabs) {
			t.classList.remove("active");
		}
		for (const c of contents) {
			c.classList.remove("active");
		}
		element.classList.add("active");
		content.classList.add("active");
	});
}

// input file preview
const previewImage = (id) => {
	document.getElementById(id).src = URL.createObjectURL(event.target.files[0]);
};

const toggleSideMenu = () => {
	document.getElementById("sidebar").classList.toggle("active");
	document.getElementById("content").classList.toggle("active");
};

$(document).ready(function () {
	$(".testimonials").owlCarousel({
		loop: true,
		margin: 15,
		rtl: false,
		nav: true,
		dots: true,
		autoplay: true,
		autoplayTimeout: 3000,
		responsive: {
			0: {
				items: 1,
			},
			768: {
				items: 2,
			},
			992: {
				items: 2,
			},
		},
	});

	$("#shareBlock").socialSharingPlugin({
		urlShare: window.location.href,
		description: $("meta[name=description]").attr("content"),
		title: $("title").text(),
	});


    //custom offcanvas
    const button = document.getElementById('customOffcanvasBtn');
    const offcanvas = document.querySelector('.custom-offcanvas');
    const closeButton = document.querySelector('.cmn-btn-close');

    if (button){
        function toggleOffcanvas() {
            offcanvas.classList.toggle('show');
        }
        button.addEventListener('click', toggleOffcanvas);
        closeButton.addEventListener('click', toggleOffcanvas);

        document.addEventListener('click', (e) => {
            if (!offcanvas.contains(e.target) && !button.contains(e.target)) {
                offcanvas.classList.remove('show');
            }
        });
    }
});



