<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Cache;

class StoreCoupon extends Model
{
    protected $table = 'store_coupons';
    protected $guarded =['id'];

    public function scopeOwn($query, $userId)
    {
        return $query->where('user_id', $userId);
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
    public function store()
    {
        return $this->belongsTo(Store::class, 'store_id');
    }

    public static function boot(): void
    {
        parent::boot();
        static::saved(function () {
            Cache::forget('storeCouponRecord');
        });
    }
}
