<?php

namespace App\Http\Middleware;

use App\Models\Store;
use App\Models\StoreProduct;
use Carbon\Carbon;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class EnsurePlan
{
	/**
	 * Handle an incoming request.
	 *
	 * @param \Illuminate\Http\Request $request
	 * @param \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
	 * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
	 */
	public function handle(Request $request, Closure $next, $module = null)
	{
		$user = auth()->user();
		$purchasePlan = $user->plan;
		if (!$purchasePlan) {
			return back()->with('error', 'Please Buy A Plan First');
		}

		if ($module == 'store') {
			$stores = Store::where('user_id', $user->id)->count();
			if ($purchasePlan->num_stores <= $stores || $purchasePlan->expiry_date < Carbon::now()) {
				return back()->with('error', 'Please Upgrade Your Plan');
			}
		} elseif ($module == 'edit') {
            $userRunningStores = Store::own(auth()->user()->id)->get();

            if (count($userRunningStores) > $purchasePlan->num_stores) {
                $lackStores = count($userRunningStores) - $purchasePlan->num_stores;
                for ($i = 0; $i < $lackStores; $i++) {
                    $userRunningStore = $userRunningStores[$i];
                    $userRunningStore->status = 0;
                    $userRunningStore->save();
                }
            }
        } elseif ($module == 'product') {
			$products = StoreProduct::where('user_id', $user->id)->count();
			if ($purchasePlan->product_qty <= $products || $purchasePlan->expiry_date < Carbon::now()) {
				return back()->with('error', 'Please Upgrade Your Plan');
			}
		} elseif ($module == 'telegram') {
			if (!$purchasePlan->telegram_bot || $purchasePlan->expiry_date < Carbon::now()) {
				return back()->with('error', 'Please Upgrade Your Plan');
			}
		} elseif ($module == 'messenger') {
			if (!$purchasePlan->messenger_bot || $purchasePlan->expiry_date < Carbon::now()) {
				return back()->with('error', 'Please Upgrade Your Plan');
			}
		} elseif ($module == 'whatsapp') {
			if (!$purchasePlan->whatsapp_bot || $purchasePlan->expiry_date < Carbon::now()) {
				return back()->with('error', 'Please Upgrade Your Plan');
			}
		}
		return $next($request);
	}
}
